/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.app.processors.ModelEventProcessor;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.repositories.IModelRepository;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import fr.obeo.perseus.server.versioning.repositories.IResourceStateRepository;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessorFactory;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManagerFactory;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

@Service
public class ModelEventProcessorFactory
implements IRepresentationEventProcessorFactory {
    private final ISubscriptionManagerFactory subscriptionManagerFactory;
    private final IModelRepository modelRepository;
    private final IIconService iconService;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final IHistoryOfModelSearchService historyOfModelSearchService;
    private final ICommitSearchService commitSearchService;
    private final ModelEntityToDTO entityToDTO;
    private final IResourceStateRepository resourceStateRepository;

    public ModelEventProcessorFactory(IModelRepository modelRepository, ISubscriptionManagerFactory subscriptionManagerFactory, IIconService iconService, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IHistoryOfModelSearchService historyOfModelSearchService, ICommitSearchService commitSearchService, ModelEntityToDTO entityToDTO, IResourceStateRepository resourceStateRepository) {
        this.subscriptionManagerFactory = Objects.requireNonNull(subscriptionManagerFactory);
        this.modelRepository = Objects.requireNonNull(modelRepository);
        this.iconService = Objects.requireNonNull(iconService);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.historyOfModelSearchService = Objects.requireNonNull(historyOfModelSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.entityToDTO = Objects.requireNonNull(entityToDTO);
        this.resourceStateRepository = Objects.requireNonNull(resourceStateRepository);
    }

    public boolean canHandle(IEditingContext editingContext, String representationId) {
        return editingContext instanceof ProjectEditingContext && PerseusRepresentationUtils.isModelRepId((String)representationId);
    }

    public Optional<IRepresentationEventProcessor> createRepresentationEventProcessor(IEditingContext editingContext, String representationId) {
        ModelEventProcessor modelEventProcessor = new ModelEventProcessor(this.modelRepository, ((ProjectEditingContext)editingContext).getProjectId(), PerseusRepresentationUtils.getModelId((String)representationId), this.subscriptionManagerFactory.create(), this.iconService, this.modelAppMessageSourceAccessor, this.historyOfModelSearchService, this.commitSearchService, this.entityToDTO, this.resourceStateRepository);
        return Optional.ofNullable(modelEventProcessor);
    }
}

