/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.app.processors.ModelObjectEventProcessor;
import fr.obeo.perseus.server.app.properties.PropertyMappingsDefinition;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.common.services.api.IUriProvider;
import fr.obeo.perseus.server.meta.services.MetamodelRegistry;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.HTMLSanitizer;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import fr.obeo.perseus.server.versioning.repositories.IResourceStateRepository;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessorFactory;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManagerFactory;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

@Service
public class ModelObjectEventProcessorFactory
implements IRepresentationEventProcessorFactory {
    private final ISubscriptionManagerFactory subscriptionManagerFactory;
    private final MetamodelRegistry mmRegistry;
    private final IModelObjectRepository modelObjectRepository;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final HTMLSanitizer htmlSanitizer;
    private final IUriProvider uriProvider;
    private final IIconService iconService;
    private final PropertyMappingsDefinition propertyMappingsDefinition;
    private final IHistoryOfModelSearchService historyOfModelSearchService;
    private final ICommitSearchService commitSearchService;
    private final ModelEntityToDTO entityToDTO;
    private final IResourceStateRepository resourceStateRepository;

    public ModelObjectEventProcessorFactory(HTMLSanitizer htmlSanitizer, MetamodelRegistry mmRegistry, IModelObjectRepository modelObjectRepository, ISubscriptionManagerFactory subscriptionManagerFactory, IUriProvider uriProvider, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IIconService iconService, PropertyMappingsDefinition propertyMappingsDefinition, IHistoryOfModelSearchService historyOfModelSearchService, ICommitSearchService commitSearchService, ModelEntityToDTO entityToDTO, IResourceStateRepository resourceStateRepository) {
        this.htmlSanitizer = Objects.requireNonNull(htmlSanitizer);
        this.mmRegistry = Objects.requireNonNull(mmRegistry);
        this.modelObjectRepository = Objects.requireNonNull(modelObjectRepository);
        this.subscriptionManagerFactory = Objects.requireNonNull(subscriptionManagerFactory);
        this.uriProvider = Objects.requireNonNull(uriProvider);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.iconService = Objects.requireNonNull(iconService);
        this.propertyMappingsDefinition = Objects.requireNonNull(propertyMappingsDefinition);
        this.historyOfModelSearchService = Objects.requireNonNull(historyOfModelSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.entityToDTO = Objects.requireNonNull(entityToDTO);
        this.resourceStateRepository = Objects.requireNonNull(resourceStateRepository);
    }

    public boolean canHandle(IEditingContext editingContext, String representationId) {
        return editingContext instanceof ProjectEditingContext && PerseusRepresentationUtils.isModelObjectRepId((String)representationId);
    }

    public Optional<IRepresentationEventProcessor> createRepresentationEventProcessor(IEditingContext editingContext, String representationId) {
        long modelId = PerseusRepresentationUtils.getModelId((String)representationId);
        String objectId = PerseusRepresentationUtils.getModelObjectId((String)representationId);
        ModelObjectEventProcessor modelObjectEventProcessor = new ModelObjectEventProcessor(this.htmlSanitizer, this.mmRegistry, this.modelObjectRepository, modelId, objectId, this.subscriptionManagerFactory.create(), this.uriProvider, ((ProjectEditingContext)editingContext).getProjectId(), this.modelAppMessageSourceAccessor, this.iconService, this.propertyMappingsDefinition, this.historyOfModelSearchService, this.commitSearchService, this.entityToDTO, this.resourceStateRepository);
        return Optional.of(modelObjectEventProcessor);
    }
}

