/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.processors.ModelObjectSnapshotEventProcessor;
import fr.obeo.perseus.server.app.properties.PropertyMappingsDefinition;
import fr.obeo.perseus.server.app.services.versioning.BaselineCreatedInput;
import fr.obeo.perseus.server.app.services.versioning.BaselineDeletedInput;
import fr.obeo.perseus.server.common.services.api.IUriProvider;
import fr.obeo.perseus.server.dto.meta.MetaclassDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.meta.services.MetamodelRegistry;
import fr.obeo.perseus.server.services.HTMLSanitizer;
import fr.obeo.perseus.server.services.api.BaselineCreatedEventPayload;
import fr.obeo.perseus.server.services.api.BaselineDeletedEventPayload;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshot;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshot;
import fr.obeo.perseus.server.services.api.model.BasicModelID;
import fr.obeo.perseus.server.services.api.model.IModelID;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.model.versioning.IModelSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import fr.obeo.perseus.server.services.api.modelobject.ModelObjectRefreshedEventPayload;
import fr.obeo.perseus.server.services.api.modelobject.ModelObjectSummary;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.ICommit;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.sirius.components.collaborative.api.ChangeDescription;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManager;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.core.api.IRepresentationInput;
import org.eclipse.sirius.components.representations.IRepresentation;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ModelObjectSnapshotEventProcessor
implements IRepresentationEventProcessor {
    private final Logger logger = LoggerFactory.getLogger(ModelObjectSnapshotEventProcessor.class);
    private final IModelObjectID modelObjectId;
    private final CommitID commitId;
    private final MetamodelRegistry mmRegistry;
    private final ICommitSearchService commitSearchService;
    private final IModelSnapshotSearchService modelSnapshotSearchService;
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;
    private final ISubscriptionManager subscriptionManager;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final Sinks.Many<IPayload> sink = Sinks.many().multicast().directBestEffort();
    private final AtomicReference<ModelObjectSummary> currentSummary = new AtomicReference();
    private final HTMLSanitizer htmlSanitizer;
    private final IUriProvider uriProvider;
    private final IIconService iconService;
    private final PropertyMappingsDefinition propertyMappingsDefinition;

    public ModelObjectSnapshotEventProcessor(IModelObjectID modelObjectId, CommitID commitId, HTMLSanitizer htmlSanitizer, MetamodelRegistry mmRegistry, ICommitSearchService commitSearchService, IModelSnapshotSearchService modelSnapshotSearchService, IModelObjectSnapshotSearchService modelObjectSnapshotSearchService, ISubscriptionManager subscriptionManager, IUriProvider diagramUriProvider, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IIconService iconService, PropertyMappingsDefinition propertyMappingsDefinition) {
        this.logger.trace("Creating the model object event processor {}", (Object)modelObjectId);
        this.modelObjectId = Objects.requireNonNull(modelObjectId);
        this.commitId = Objects.requireNonNull(commitId);
        this.htmlSanitizer = Objects.requireNonNull(htmlSanitizer);
        this.mmRegistry = Objects.requireNonNull(mmRegistry);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.modelSnapshotSearchService = Objects.requireNonNull(modelSnapshotSearchService);
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
        this.subscriptionManager = Objects.requireNonNull(subscriptionManager);
        this.uriProvider = Objects.requireNonNull(diagramUriProvider);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.iconService = Objects.requireNonNull(iconService);
        this.propertyMappingsDefinition = Objects.requireNonNull(propertyMappingsDefinition);
        ModelObjectSummary summary = this.refreshSummary();
        this.currentSummary.set(summary);
    }

    public IRepresentation getRepresentation() {
        return (IRepresentation)this.currentSummary.get();
    }

    public ISubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void handle(Sinks.One<IPayload> payloadSink, Sinks.Many<ChangeDescription> changeDescriptionSink, IRepresentationInput representationInput) {
    }

    public void refresh(ChangeDescription changeDescription) {
        Sinks.EmitResult emitResult;
        BaselineCreatedEventPayload payload = null;
        if ("HISTORY_CHANGE".equals(changeDescription.getKind())) {
            BaselineDeletedInput baselineDeletedInput;
            IInput input = changeDescription.getInput();
            if (input instanceof BaselineCreatedInput) {
                BaselineCreatedInput baselineCreatedInput = (BaselineCreatedInput)input;
                if (baselineCreatedInput.modelId() == this.modelObjectId.getModelId()) {
                    payload = new BaselineCreatedEventPayload(input.id(), baselineCreatedInput.baseline());
                }
            } else if (input instanceof BaselineDeletedInput && (baselineDeletedInput = (BaselineDeletedInput)input).modelId() == this.modelObjectId.getModelId()) {
                payload = new BaselineDeletedEventPayload(input.id(), baselineDeletedInput.baselineId());
            }
        }
        if (payload != null && this.sink.currentSubscriberCount() > 0 && (emitResult = this.sink.tryEmitNext(payload)).isFailure()) {
            String pattern = "An error has occurred while emitting a ModelRefreshedEventPayload: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }

    private ModelObjectSummary refreshSummary() {
        ModelObjectSummary summary;
        ICommit commit = (ICommit)this.commitSearchService.findCommit(this.modelObjectId.getProjectId(), this.commitId).orElseThrow();
        Optional optModelSnapshot = this.modelSnapshotSearchService.findModelSnapshot((IModelID)new BasicModelID(this.modelObjectId.getProjectId(), this.modelObjectId.getModelId()), commit);
        Optional optModelObjectSnapshot = this.modelObjectSnapshotSearchService.findModelObjectInCommit(this.modelObjectId, commit);
        if (optModelObjectSnapshot.isEmpty() || optModelSnapshot.isEmpty()) {
            summary = ModelObjectSummary.builder().setUid(this.modelObjectId.getObjectId()).setProjectId(this.modelObjectId.getProjectId()).setModelUid(this.modelObjectId.getModelId()).setName(this.modelAppMessageSourceAccessor.getMessage("unknown.object.name")).setType(new MetaclassQName(MetaclassDTO.unknown().getName(), MetaclassDTO.unknown().getMetamodelURI().toString())).setDescription(this.modelAppMessageSourceAccessor.getMessage("unknown.object.desc")).setImageURL("/api/images/static/images/UnknownType.png").build();
        } else {
            ModelSnapshot modelSnapshot = (ModelSnapshot)optModelSnapshot.get();
            ModelObjectSnapshot moSnapshot = (ModelObjectSnapshot)optModelObjectSnapshot.get();
            ModelObjectSnapshotToRepresentation converter = new ModelObjectSnapshotToRepresentation(this.modelObjectId, commit, modelSnapshot, moSnapshot, this.mmRegistry, this.modelObjectSnapshotSearchService, this.htmlSanitizer, this.uriProvider, this.iconService, this.propertyMappingsDefinition);
            summary = converter.build();
        }
        this.logger.trace("Summary refreshed: {}", (Object)summary.getId());
        return summary;
    }

    public Flux<IPayload> getOutputEvents(IInput input) {
        Mono initialRefresh = Mono.fromCallable(() -> new ModelObjectRefreshedEventPayload(input.id(), (ModelObjectSummary)this.currentSummary.get()));
        Flux refreshEventFlux = Flux.concat((Publisher[])new Publisher[]{initialRefresh, this.sink.asFlux()});
        return Flux.merge((Publisher[])new Publisher[]{refreshEventFlux, this.subscriptionManager.getFlux(input)});
    }

    public void dispose() {
        this.subscriptionManager.dispose();
        Sinks.EmitResult emitResult = this.sink.tryEmitComplete();
        if (emitResult.isFailure()) {
            String pattern = "An error has occurred while marking the publisher as complete: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }
}

