/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.FullCommitID;
import fr.obeo.perseus.server.app.processors.ModelObjectSnapshotEventProcessor;
import fr.obeo.perseus.server.app.properties.PropertyMappingsDefinition;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.common.services.api.IUriProvider;
import fr.obeo.perseus.server.meta.services.MetamodelRegistry;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.HTMLSanitizer;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.model.versioning.IModelSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.BasicModelObjectID;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessorFactory;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManagerFactory;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

@Service
public class ModelObjectSnapshotEventProcessorFactory
implements IRepresentationEventProcessorFactory {
    private final ISubscriptionManagerFactory subscriptionManagerFactory;
    private final MetamodelRegistry mmRegistry;
    private final ICommitSearchService commitSearchService;
    private final IModelSnapshotSearchService modelSnapshotSearchService;
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final HTMLSanitizer htmlSanitizer;
    private final IUriProvider uriProvider;
    private final IIconService iconService;
    private final PropertyMappingsDefinition propertyMappingsDefinition;

    public ModelObjectSnapshotEventProcessorFactory(HTMLSanitizer htmlSanitizer, MetamodelRegistry mmRegistry, ICommitSearchService commitSearchService, IModelSnapshotSearchService modelSnapshotSearchService, IModelObjectSnapshotSearchService modelObjectSnapshotSearchService, IModelObjectRepository modelObjectRepository, ISubscriptionManagerFactory subscriptionManagerFactory, IUriProvider uriProvider, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IIconService iconService, PropertyMappingsDefinition propertyMappingsDefinition) {
        this.htmlSanitizer = Objects.requireNonNull(htmlSanitizer);
        this.mmRegistry = Objects.requireNonNull(mmRegistry);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.modelSnapshotSearchService = Objects.requireNonNull(modelSnapshotSearchService);
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
        this.subscriptionManagerFactory = Objects.requireNonNull(subscriptionManagerFactory);
        this.uriProvider = Objects.requireNonNull(uriProvider);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.iconService = Objects.requireNonNull(iconService);
        this.propertyMappingsDefinition = Objects.requireNonNull(propertyMappingsDefinition);
    }

    public boolean canHandle(IEditingContext editingContext, String representationId) {
        return editingContext instanceof CommitEditingContext && PerseusRepresentationUtils.isModelObjectRepId((String)representationId);
    }

    public Optional<IRepresentationEventProcessor> createRepresentationEventProcessor(IEditingContext editingContext, String representationId) {
        if (editingContext instanceof CommitEditingContext) {
            CommitEditingContext commitEditingContext = (CommitEditingContext)editingContext;
            FullCommitID fullCommitId = commitEditingContext.getFullCommitId();
            long modelId = PerseusRepresentationUtils.getModelId((String)representationId);
            String objectId = PerseusRepresentationUtils.getModelObjectId((String)representationId);
            BasicModelObjectID moID = new BasicModelObjectID(fullCommitId.projectId(), modelId, objectId);
            ModelObjectSnapshotEventProcessor modelObjectEventProcessor = new ModelObjectSnapshotEventProcessor((IModelObjectID)moID, fullCommitId.commitId(), this.htmlSanitizer, this.mmRegistry, this.commitSearchService, this.modelSnapshotSearchService, this.modelObjectSnapshotSearchService, this.subscriptionManagerFactory.create(), this.uriProvider, this.modelAppMessageSourceAccessor, this.iconService, this.propertyMappingsDefinition);
            return Optional.of(modelObjectEventProcessor);
        }
        return Optional.empty();
    }
}

