/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.services.versioning.BaselineCreatedInput;
import fr.obeo.perseus.server.app.services.versioning.BaselineDeletedInput;
import fr.obeo.perseus.server.common.services.api.IUriProvider;
import fr.obeo.perseus.server.services.api.BaselineCreatedEventPayload;
import fr.obeo.perseus.server.services.api.BaselineDeletedEventPayload;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.dto.versioning.DerivedModelData;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshot;
import fr.obeo.perseus.server.services.api.model.BasicModelID;
import fr.obeo.perseus.server.services.api.model.IModelID;
import fr.obeo.perseus.server.services.api.model.ModelRefreshedEventPayload;
import fr.obeo.perseus.server.services.api.model.ModelSummary;
import fr.obeo.perseus.server.services.api.model.versioning.IModelSnapshotSearchService;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.ICommit;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.sirius.components.collaborative.api.ChangeDescription;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManager;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.core.api.IRepresentationInput;
import org.eclipse.sirius.components.representations.IRepresentation;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ModelSnapshotEventProcessor
implements IRepresentationEventProcessor {
    private final Logger logger = LoggerFactory.getLogger(ModelSnapshotEventProcessor.class);
    private final IModelID modelId;
    private final CommitID commitId;
    private final ICommitSearchService commitSearchService;
    private final IModelSnapshotSearchService modelSnapshotSearchService;
    private final ISubscriptionManager subscriptionManager;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final Sinks.Many<IPayload> sink = Sinks.many().multicast().directBestEffort();
    private final AtomicReference<ModelSummary> currentSummary = new AtomicReference();
    private final IIconService iconService;

    public ModelSnapshotEventProcessor(IModelID modelId, CommitID commitId, ICommitSearchService commitSearchService, IModelSnapshotSearchService modelSnapshotSearchService, ISubscriptionManager subscriptionManager, IUriProvider diagramUriProvider, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IIconService iconService) {
        this.logger.trace("Creating the model event processor {}", (Object)modelId);
        this.modelId = Objects.requireNonNull(modelId);
        this.commitId = Objects.requireNonNull(commitId);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.modelSnapshotSearchService = Objects.requireNonNull(modelSnapshotSearchService);
        this.subscriptionManager = Objects.requireNonNull(subscriptionManager);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.iconService = Objects.requireNonNull(iconService);
        ModelSummary summary = this.refreshSummary();
        this.currentSummary.set(summary);
    }

    public IRepresentation getRepresentation() {
        return (IRepresentation)this.currentSummary.get();
    }

    public ISubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void handle(Sinks.One<IPayload> payloadSink, Sinks.Many<ChangeDescription> changeDescriptionSink, IRepresentationInput representationInput) {
    }

    public void refresh(ChangeDescription changeDescription) {
        Sinks.EmitResult emitResult;
        BaselineCreatedEventPayload payload = null;
        if ("HISTORY_CHANGE".equals(changeDescription.getKind())) {
            BaselineDeletedInput baselineDeletedInput;
            IInput input = changeDescription.getInput();
            if (input instanceof BaselineCreatedInput) {
                BaselineCreatedInput baselineCreatedInput = (BaselineCreatedInput)input;
                if (baselineCreatedInput.modelId() == this.modelId.getModelId()) {
                    payload = new BaselineCreatedEventPayload(input.id(), baselineCreatedInput.baseline());
                }
            } else if (input instanceof BaselineDeletedInput && (baselineDeletedInput = (BaselineDeletedInput)input).modelId() == this.modelId.getModelId()) {
                payload = new BaselineDeletedEventPayload(input.id(), baselineDeletedInput.baselineId());
            }
        }
        if (payload != null && this.sink.currentSubscriberCount() > 0 && (emitResult = this.sink.tryEmitNext(payload)).isFailure()) {
            String pattern = "An error has occurred while emitting a ModelRefreshedEventPayload: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }

    private ModelSummary refreshSummary() {
        ICommit commit = (ICommit)this.commitSearchService.findCommit(this.modelId.getProjectId(), this.commitId).orElseThrow();
        Optional optModelSnapshot = this.modelSnapshotSearchService.findModelSnapshot((IModelID)new BasicModelID(this.modelId.getProjectId(), this.modelId.getModelId()), commit);
        if (!optModelSnapshot.isEmpty()) {
            ModelSnapshot modelSnapshot = (ModelSnapshot)optModelSnapshot.get();
            String name = modelSnapshot.intrinsic().getName();
            String description = modelSnapshot.intrinsic().getDescription();
            String imageURL = Optional.ofNullable(modelSnapshot.derived()).flatMap(DerivedModelData::iconHash).map(iconHash -> "/api/images" + this.iconService.getModelIconPath(iconHash)).orElse("/api/images/static/images/UnknownType.png");
            ModelSummary summary = ModelSummary.builder((boolean)true).setUid(String.valueOf(this.modelId.getModelId())).setProjectId(this.modelId.getProjectId()).setName(name).setDescription(description).setImageURL(imageURL).build();
            return summary;
        }
        ModelSummary summary = ModelSummary.builder((boolean)false).setUid(String.valueOf(this.modelId.getModelId())).setProjectId(this.modelId.getProjectId()).setName(this.modelAppMessageSourceAccessor.getMessage("unknown.object.name")).setDescription(this.modelAppMessageSourceAccessor.getMessage("unknown.object.desc")).setImageURL("/api/images/static/images/UnknownType.png").build();
        this.logger.trace("Summary refreshed: {}", (Object)summary.getId());
        return summary;
    }

    public Flux<IPayload> getOutputEvents(IInput input) {
        Mono initialRefresh = Mono.fromCallable(() -> new ModelRefreshedEventPayload(input.id(), (ModelSummary)this.currentSummary.get()));
        Flux refreshEventFlux = Flux.concat((Publisher[])new Publisher[]{initialRefresh, this.sink.asFlux()});
        return Flux.merge((Publisher[])new Publisher[]{refreshEventFlux, this.subscriptionManager.getFlux(input)});
    }

    public void dispose() {
        this.subscriptionManager.dispose();
        Sinks.EmitResult emitResult = this.sink.tryEmitComplete();
        if (emitResult.isFailure()) {
            String pattern = "An error has occurred while marking the publisher as complete: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }
}

