/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.processors.PerseusEditingContextEventProcessor;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Objects;
import org.eclipse.sirius.components.collaborative.api.IDanglingRepresentationDeletionService;
import org.eclipse.sirius.components.collaborative.api.IEditingContextEventHandler;
import org.eclipse.sirius.components.collaborative.api.IEditingContextEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IEditingContextEventProcessorFactory;
import org.eclipse.sirius.components.collaborative.api.IInputPostProcessor;
import org.eclipse.sirius.components.collaborative.api.IInputPreProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessorComposedFactory;
import org.eclipse.sirius.components.collaborative.editingcontext.EditingContextEventProcessorFactoryParameters;
import org.eclipse.sirius.components.collaborative.editingcontext.EditingContextEventProcessorParameters;
import org.eclipse.sirius.components.collaborative.editingcontext.api.IEditingContextEventProcessorExecutorServiceProvider;
import org.eclipse.sirius.components.collaborative.representations.api.IRepresentationEventProcessorRegistry;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IEditingContextPersistenceService;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class PerseusEditingContextEventProcessorFactory
implements IEditingContextEventProcessorFactory {
    private final IDanglingRepresentationDeletionService representationDeletionService;
    private final IRepresentationEventProcessorRegistry representationEventProcessorRegistry;
    private final IEditingContextPersistenceService editingContextPersistenceService;
    private final List<IEditingContextEventHandler> editingContextEventHandlers;
    private final IRepresentationEventProcessorComposedFactory representationEventProcessorComposedFactory;
    private final IEditingContextEventProcessorExecutorServiceProvider executorServiceProvider;
    private final List<IInputPreProcessor> inputPreProcessors;
    private final List<IInputPostProcessor> inputPostProcessors;
    private final MeterRegistry meterRegistry;

    public PerseusEditingContextEventProcessorFactory(IDanglingRepresentationDeletionService representationDeletionService, IRepresentationEventProcessorRegistry representationEventProcessorRegistry, EditingContextEventProcessorFactoryParameters parameters) {
        this.representationDeletionService = Objects.requireNonNull(representationDeletionService);
        this.representationEventProcessorRegistry = Objects.requireNonNull(representationEventProcessorRegistry);
        this.editingContextPersistenceService = parameters.getEditingContextPersistenceService();
        this.editingContextEventHandlers = parameters.getEditingContextEventHandlers();
        this.representationEventProcessorComposedFactory = parameters.getRepresentationEventProcessorComposedFactory();
        this.executorServiceProvider = parameters.getExecutorServiceProvider();
        this.inputPreProcessors = parameters.getInputPreProcessors();
        this.inputPostProcessors = parameters.getInputPostProcessors();
        this.meterRegistry = parameters.getMeterRegistry();
    }

    public IEditingContextEventProcessor createEditingContextEventProcessor(IEditingContext editingContext) {
        EditingContextEventProcessorParameters parameters = EditingContextEventProcessorParameters.newEditingContextEventProcessorParameters().editingContext(editingContext).danglingRepresentationDeletionService(this.representationDeletionService).representationEventProcessorRegistry(this.representationEventProcessorRegistry).editingContextPersistenceService(this.editingContextPersistenceService).editingContextEventHandlers(this.editingContextEventHandlers).representationEventProcessorComposedFactory(this.representationEventProcessorComposedFactory).executorServiceProvider(this.executorServiceProvider).inputPreProcessors(this.inputPreProcessors).inputPostProcessors(this.inputPostProcessors).meterRegistry(this.meterRegistry).build();
        return new PerseusEditingContextEventProcessor(parameters);
    }
}

