/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.services.versioning.BaselineCreatedInput;
import fr.obeo.perseus.server.app.services.versioning.BaselineDeletedInput;
import fr.obeo.perseus.server.app.services.versioning.NewCommitInput;
import fr.obeo.perseus.server.jama.polling.PollingUpdateErrorMessageInput;
import fr.obeo.perseus.server.jama.polling.PollingUpdateOslcLinksInput;
import fr.obeo.perseus.server.oslc.api.graphql.CreateOslcAssociationInput;
import fr.obeo.perseus.server.oslc.api.graphql.DeleteOslcAssociationInput;
import fr.obeo.perseus.server.oslc.api.graphql.ForceDeleteModelOslcLinksInput;
import fr.obeo.perseus.server.oslc.api.graphql.RetryOslcLinksInput;
import fr.obeo.perseus.server.oslc.globalconf.api.graphql.AssignModelGlobalConfInput;
import fr.obeo.perseus.server.oslc.globalconf.api.graphql.SetCurrentUserGlobalConfInput;
import fr.obeo.perseus.server.oslc.services.OslcLinkService;
import fr.obeo.perseus.server.services.api.IModelService;
import fr.obeo.perseus.server.services.api.attachments.DeleteExtAttachmentsInput;
import fr.obeo.perseus.server.services.api.attachments.RetryUnsynchronizedAttachmentsInput;
import fr.obeo.perseus.server.services.api.model.ModelSaveInput;
import fr.obeo.perseus.server.services.api.project.PerseusProjectRefreshedEventPayload;
import fr.obeo.perseus.server.services.api.project.ProjectSummary;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.sirius.components.collaborative.api.ChangeDescription;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManager;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.core.api.IRepresentationInput;
import org.eclipse.sirius.components.representations.IRepresentation;
import org.eclipse.sirius.web.application.project.services.api.IProjectEditingContextService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class PerseusProjectEventProcessor
implements IRepresentationEventProcessor {
    private final Logger logger = LoggerFactory.getLogger(PerseusProjectEventProcessor.class);
    private final String representationId;
    private final ISubscriptionManager subscriptionManager;
    private final Sinks.Many<IPayload> sink = Sinks.many().multicast().directBestEffort();
    private final AtomicReference<ProjectSummary> currentSummary = new AtomicReference();
    private final IProjectEditingContextService projectEditingContextService;
    private final List<String> supportedChangeKinds = List.of("SEMANTIC_CHANGE", "HISTORY_CHANGE", "LINK_CHANGE", "ATTACHMENT_CHANGE", "PROJECT_SETTINGS_CHANGE");

    public PerseusProjectEventProcessor(String representationId, ISubscriptionManager subscriptionManager, IModelService modelService, IProjectEditingContextService projectEditingContextService) {
        this.logger.trace("Creating the project event processor {}", (Object)representationId);
        this.representationId = Objects.requireNonNull(representationId);
        this.subscriptionManager = Objects.requireNonNull(subscriptionManager);
        this.projectEditingContextService = Objects.requireNonNull(projectEditingContextService);
        ProjectSummary summary = this.refreshSummary();
        this.currentSummary.set(summary);
    }

    public IRepresentation getRepresentation() {
        return (IRepresentation)this.currentSummary.get();
    }

    public ISubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void handle(Sinks.One<IPayload> payloadSink, Sinks.Many<ChangeDescription> changeDescriptionSink, IRepresentationInput representationInput) {
    }

    public void refresh(ChangeDescription changeDescription) {
        Optional optEditingContextId = this.projectEditingContextService.getEditingContextId(this.representationId);
        if (optEditingContextId.isPresent() && this.supportedChangeKinds.contains(changeDescription.getKind())) {
            IInput input = changeDescription.getInput();
            String editingContextId = (String)optEditingContextId.get();
            boolean related = false;
            if (input instanceof AssignModelGlobalConfInput) {
                AssignModelGlobalConfInput assignModelGlobalConfInput = (AssignModelGlobalConfInput)input;
                related = editingContextId.equals(assignModelGlobalConfInput.editingContextId());
            } else if (input instanceof SetCurrentUserGlobalConfInput) {
                SetCurrentUserGlobalConfInput setCurrentUserGlobalConfInput = (SetCurrentUserGlobalConfInput)input;
                related = editingContextId.equals(setCurrentUserGlobalConfInput.editingContextId());
            } else if (input instanceof ModelSaveInput) {
                ModelSaveInput modelSaveInput = (ModelSaveInput)input;
                related = modelSaveInput.modelUpdate().getProjectId().equals(this.representationId);
            } else if (input instanceof PollingUpdateOslcLinksInput) {
                PollingUpdateOslcLinksInput pollingUpdateOslcLinksInput = (PollingUpdateOslcLinksInput)input;
                related = editingContextId.equals(pollingUpdateOslcLinksInput.editingContextId());
            } else if (input instanceof OslcLinkService.ModelSaveInputAdapter) {
                OslcLinkService.ModelSaveInputAdapter modelSaveInputAdapter = (OslcLinkService.ModelSaveInputAdapter)input;
                related = editingContextId.equals(modelSaveInputAdapter.editingContextId());
            } else if (input instanceof ForceDeleteModelOslcLinksInput) {
                ForceDeleteModelOslcLinksInput forceDeleteModelOslcLinksInput = (ForceDeleteModelOslcLinksInput)input;
                related = editingContextId.equals(forceDeleteModelOslcLinksInput.editingContextId());
            } else if (input instanceof RetryOslcLinksInput) {
                RetryOslcLinksInput retryOslcLinksInput = (RetryOslcLinksInput)input;
                related = editingContextId.equals(retryOslcLinksInput.editingContextId());
            } else if (input instanceof RetryUnsynchronizedAttachmentsInput) {
                RetryUnsynchronizedAttachmentsInput retryUnsynchronizedAttachmentsInput = (RetryUnsynchronizedAttachmentsInput)input;
                related = editingContextId.equals(retryUnsynchronizedAttachmentsInput.editingContextId());
            } else if (input instanceof DeleteExtAttachmentsInput) {
                DeleteExtAttachmentsInput deleteExtAttachmentsInput = (DeleteExtAttachmentsInput)input;
                related = editingContextId.equals(deleteExtAttachmentsInput.editingContextId());
            } else if (input instanceof PollingUpdateErrorMessageInput) {
                PollingUpdateErrorMessageInput pollingUpdateErrorMessageInput = (PollingUpdateErrorMessageInput)input;
                related = this.representationId.equals(pollingUpdateErrorMessageInput.projectId());
            } else if (input instanceof CreateOslcAssociationInput) {
                CreateOslcAssociationInput createOslcAssociationInput = (CreateOslcAssociationInput)input;
                related = this.representationId.equals(createOslcAssociationInput.projectId());
            } else if (input instanceof DeleteOslcAssociationInput) {
                DeleteOslcAssociationInput deleteOslcAssociationInput = (DeleteOslcAssociationInput)input;
                related = this.representationId.equals(deleteOslcAssociationInput.projectId());
            } else if (input instanceof BaselineCreatedInput) {
                related = editingContextId.equals(changeDescription.getSourceId());
            } else if (input instanceof BaselineDeletedInput) {
                related = editingContextId.equals(changeDescription.getSourceId());
            } else if (input instanceof NewCommitInput) {
                related = editingContextId.equals(changeDescription.getSourceId());
            }
            if (related) {
                Sinks.EmitResult emitResult;
                ProjectSummary summary = this.refreshSummary();
                this.currentSummary.set(summary);
                if (this.sink.currentSubscriberCount() > 0 && (emitResult = this.sink.tryEmitNext((Object)new PerseusProjectRefreshedEventPayload(changeDescription.getInput().id(), summary))).isFailure()) {
                    String pattern = "An error has occurred while emitting a ProjectRefreshedEventPayload: {}";
                    this.logger.warn(pattern, (Object)emitResult);
                }
            }
        }
    }

    private ProjectSummary refreshSummary() {
        return new ProjectSummary(this.representationId);
    }

    public Flux<IPayload> getOutputEvents(IInput input) {
        Mono initialRefresh = Mono.fromCallable(() -> new PerseusProjectRefreshedEventPayload(input.id(), (ProjectSummary)this.currentSummary.get()));
        Flux refreshEventFlux = Flux.concat((Publisher[])new Publisher[]{initialRefresh, this.sink.asFlux()});
        return Flux.merge((Publisher[])new Publisher[]{refreshEventFlux, this.subscriptionManager.getFlux(input)});
    }

    public void dispose() {
        this.subscriptionManager.dispose();
        Sinks.EmitResult emitResult = this.sink.tryEmitComplete();
        if (emitResult.isFailure()) {
            String pattern = "An error has occurred while marking the publisher as complete: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }
}

