/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.properties;

import fr.obeo.perseus.server.app.properties.ModelObjectNodeStructuralFeaturesIfDescriptionProvider;
import fr.obeo.perseus.server.app.properties.ModelObjectSnapshotStructuralFeaturesIfDescriptionProvider;
import fr.obeo.perseus.server.app.properties.PropertyMappingsDefinition;
import fr.obeo.perseus.server.app.properties.WidgetMapping;
import fr.obeo.perseus.server.dto.meta.MClassifierDTO;
import fr.obeo.perseus.server.dto.meta.MStructuralFeatureDTO;
import fr.obeo.perseus.server.dto.meta.MetaclassDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.meta.services.api.IMetaclassRegistry;
import fr.obeo.perseus.server.meta.services.api.IMetamodelRegistry;
import fr.obeo.perseus.server.model.domain.mappings.ModelSnapshotContext;
import fr.obeo.perseus.server.services.IModelContext;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshot;
import fr.obeo.perseus.server.services.api.model.versioning.IModelSnapshotSearchService;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.forms.description.ForDescription;
import org.eclipse.sirius.components.forms.description.GroupDescription;
import org.eclipse.sirius.components.forms.description.IfDescription;
import org.eclipse.sirius.components.representations.VariableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Component;

@Component
public class ModelObjectGroupDescriptionProvider {
    public static final String VAR_COMMIT = "commit";
    public static final String VAR_MODEL_SNAPSHOT = "modelSnapshot";
    public static final String VAR_MODEL_SNAPSHOT_CONTEXT = "modelSnapshotContext";
    public static final String STRUCTURAL_FEATURE = "structuralFeature";
    private static final Logger LOG = LoggerFactory.getLogger(ModelObjectGroupDescriptionProvider.class);
    private final Function<Long, IModelContext> modelContextProvider;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final IIdentityService identityService;
    private final IMetamodelRegistry mmRegistry;
    private final IMetaclassRegistry metaclassRegistry;
    private final Function<VariableManager, String> semanticTargetIdProvider;
    private final PropertyMappingsDefinition propertyMappingsDefinition;
    private final ICommitSearchService commitSearchService;
    private final IModelSnapshotSearchService modelSnapshotSearchService;
    private final ModelObjectNodeStructuralFeaturesIfDescriptionProvider nodeStructuralFeaturesIfDescriptionProvider;
    private final ModelObjectSnapshotStructuralFeaturesIfDescriptionProvider snapshotStructuralFeaturesIfDescriptionProvider;

    public ModelObjectGroupDescriptionProvider(Function<Long, IModelContext> modelContextProvider, IIdentityService identityService, PropertyMappingsDefinition propertyMappingsDefinition, IMetamodelRegistry mmRegistry, IMetaclassRegistry metaclassRegistry, ICommitSearchService commitSearchService, IModelSnapshotSearchService modelSnapshotSearchService, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, ModelObjectNodeStructuralFeaturesIfDescriptionProvider nodeStructuralFeaturesIfDescriptionProvider, ModelObjectSnapshotStructuralFeaturesIfDescriptionProvider snapshotStructuralFeaturesIfDescriptionProvider) {
        this.modelContextProvider = Objects.requireNonNull(modelContextProvider);
        this.identityService = Objects.requireNonNull(identityService);
        this.propertyMappingsDefinition = Objects.requireNonNull(propertyMappingsDefinition);
        this.mmRegistry = Objects.requireNonNull(mmRegistry);
        this.metaclassRegistry = Objects.requireNonNull(metaclassRegistry);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.modelSnapshotSearchService = Objects.requireNonNull(modelSnapshotSearchService);
        this.nodeStructuralFeaturesIfDescriptionProvider = Objects.requireNonNull(nodeStructuralFeaturesIfDescriptionProvider);
        this.snapshotStructuralFeaturesIfDescriptionProvider = Objects.requireNonNull(snapshotStructuralFeaturesIfDescriptionProvider);
        this.semanticTargetIdProvider = variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElse(null);
    }

    private boolean nodeHasPropertyMapping(VariableManager vm) {
        return vm.get("self", ModelObjectNode.class).map(ModelObjectNode::getMetaclassId).map(mcId -> this.metaclassRegistry.getMetaclassByUid(mcId.longValue())).map(mc -> mc.isPresent() && this.propertyMappingsDefinition.hasMapping((MetaclassDTO)mc.get())).orElse(false);
    }

    private boolean snapshotHasPropertyMapping(VariableManager vm) {
        return vm.get("self", ModelObjectSnapshotNode.class).map(snapshot -> snapshot.snapshot().getIntrinsic().getMetaclass()).map(metaclassQName -> this.propertyMappingsDefinition.hasMapping(metaclassQName)).orElse(false);
    }

    public GroupDescription getModelObjectGroupDescription() {
        return GroupDescription.newGroupDescription((String)"ModelObjectGroupID").idProvider(variableManager -> "Model Object Properties").labelProvider(variableManager -> this.modelAppMessageSourceAccessor.getMessage("props.group.mo.label")).semanticElementsProvider(variableManager -> {
            Object self = variableManager.getVariables().get("self");
            if (self instanceof ModelObjectNode) {
                ModelObjectNode mon = (ModelObjectNode)self;
                variableManager.put("modelContext", this.modelContextProvider.apply(mon.getModelId()));
            } else if (self instanceof ModelObjectSnapshotNode) {
                ModelObjectSnapshotNode imos = (ModelObjectSnapshotNode)self;
                this.commitSearchService.findCommit(imos.model().id().getProjectId(), imos.model().commitId()).ifPresent(commit -> {
                    variableManager.put(VAR_COMMIT, commit);
                    this.modelSnapshotSearchService.findModelSnapshot(imos.model().id(), commit).ifPresent(modelSnapshot -> {
                        variableManager.put(VAR_MODEL_SNAPSHOT, modelSnapshot);
                        variableManager.put(VAR_MODEL_SNAPSHOT_CONTEXT, (Object)new ModelSnapshotContext(modelSnapshot, this.mmRegistry, this.metaclassRegistry));
                    });
                });
            }
            return Collections.singletonList(self);
        }).controlDescriptions(List.of(IfDescription.newIfDescription((String)"IsModelObjectNode").predicate(vm -> vm.get("self", ModelObjectNode.class).isPresent()).controlDescriptions(List.of(IfDescription.newIfDescription((String)"HasMapping").predicate(arg_0 -> this.nodeHasPropertyMapping(arg_0)).controlDescriptions(List.of(ForDescription.newForDescription((String)"forEachMapping").targetObjectIdProvider(this.semanticTargetIdProvider).iterator(STRUCTURAL_FEATURE).iterableProvider(arg_0 -> this.getMappedStructuralFeatures(arg_0)).controlDescriptions(this.nodeStructuralFeaturesIfDescriptionProvider.getIfDescriptions()).build())).targetObjectIdProvider(this.semanticTargetIdProvider).build(), IfDescription.newIfDescription((String)"HasNoMapping").predicate(vm -> !this.nodeHasPropertyMapping(vm)).controlDescriptions(List.of(ForDescription.newForDescription((String)"forEachSF").targetObjectIdProvider(this.semanticTargetIdProvider).iterator(STRUCTURAL_FEATURE).iterableProvider(arg_0 -> this.getDefaultStructuralFeatures(arg_0)).controlDescriptions(this.nodeStructuralFeaturesIfDescriptionProvider.getIfDescriptions()).build())).targetObjectIdProvider(this.semanticTargetIdProvider).build())).targetObjectIdProvider(this.semanticTargetIdProvider).build(), IfDescription.newIfDescription((String)"IsSnapshot").predicate(vm -> vm.get("self", ModelObjectSnapshotNode.class).isPresent()).controlDescriptions(List.of(IfDescription.newIfDescription((String)"HasMapping").predicate(arg_0 -> this.snapshotHasPropertyMapping(arg_0)).controlDescriptions(List.of(ForDescription.newForDescription((String)"forEachMapping").targetObjectIdProvider(this.semanticTargetIdProvider).iterator(STRUCTURAL_FEATURE).iterableProvider(arg_0 -> this.getMappedStructuralFeaturesInSnapshot(arg_0)).controlDescriptions(this.snapshotStructuralFeaturesIfDescriptionProvider.getIfDescriptions()).build())).targetObjectIdProvider(this.semanticTargetIdProvider).build(), IfDescription.newIfDescription((String)"HasNoMapping").predicate(vm -> !this.snapshotHasPropertyMapping(vm)).controlDescriptions(List.of(ForDescription.newForDescription((String)"forEachSF").targetObjectIdProvider(this.semanticTargetIdProvider).iterator(STRUCTURAL_FEATURE).iterableProvider(arg_0 -> this.getDefaultStructuralFeaturesInSnapshot(arg_0)).controlDescriptions(this.snapshotStructuralFeaturesIfDescriptionProvider.getIfDescriptions()).build())).targetObjectIdProvider(this.semanticTargetIdProvider).build())).targetObjectIdProvider(this.semanticTargetIdProvider).build())).build();
    }

    private List<Object> getMappedStructuralFeatures(VariableManager variableManager) {
        MetaclassDTO metaclass = (MetaclassDTO)variableManager.get("self", ModelObjectNode.class).map(ModelObjectNode::getMetaclassId).flatMap(mcId -> this.metaclassRegistry.getMetaclassByUid(mcId.longValue())).get();
        List widgetMappings = this.propertyMappingsDefinition.getMappings(metaclass);
        variableManager.put("widgetMappings", (Object)widgetMappings);
        ModelObjectNode self = (ModelObjectNode)variableManager.get("self", ModelObjectNode.class).get();
        IModelContext modelContext = (IModelContext)this.modelContextProvider.apply(self.getModelId());
        Map structuralFeatures = modelContext.getAllStructuralFeatures(self.getMetaclassId());
        ArrayList<Object> objects = new ArrayList<Object>();
        for (WidgetMapping next : widgetMappings) {
            MStructuralFeatureDTO sf = (MStructuralFeatureDTO)structuralFeatures.get(next.name());
            if (sf != null) {
                objects.add(sf);
                continue;
            }
            LOG.warn(String.format("Invalid mapping for structural feature %s on meta-class %s", next.name(), metaclass.getName()));
        }
        return objects;
    }

    private MetaclassDTO getMetaclass(ModelSnapshot modelSnapshot, MetaclassQName metaclassQName) {
        return modelSnapshot.intrinsic().getMetamodels().values().stream().filter(info -> info.getNsURI().equals(metaclassQName.nsUri())).findFirst().flatMap(mmInfo -> this.mmRegistry.getMetamodelByHash(mmInfo.getHash())).map(mmDTO -> (MClassifierDTO)mmDTO.getClassifiers().get(metaclassQName.name())).filter(MetaclassDTO.class::isInstance).map(MetaclassDTO.class::cast).orElseGet(MetaclassDTO::unknown);
    }

    private List<Object> getMappedStructuralFeaturesInSnapshot(VariableManager variableManager) {
        Optional optSelf = variableManager.get("self", ModelObjectSnapshotNode.class);
        Optional optModelSnapshot = variableManager.get(VAR_MODEL_SNAPSHOT, ModelSnapshot.class);
        Optional optSnapshotContext = variableManager.get(VAR_MODEL_SNAPSHOT_CONTEXT, ModelSnapshotContext.class);
        if (optSelf.isPresent() && optModelSnapshot.isPresent() && optSnapshotContext.isPresent()) {
            ModelObjectSnapshotNode self = (ModelObjectSnapshotNode)optSelf.get();
            ModelSnapshot modelSnapshot = (ModelSnapshot)optModelSnapshot.get();
            ModelSnapshotContext snapshotContext = (ModelSnapshotContext)optSnapshotContext.get();
            MetaclassQName mcQName = self.snapshot().getIntrinsic().getMetaclass();
            MetaclassDTO metaclass = this.getMetaclass(modelSnapshot, mcQName);
            List widgetMappings = this.propertyMappingsDefinition.getMappings(metaclass);
            variableManager.put("widgetMappings", (Object)widgetMappings);
            Map structuralFeatures = snapshotContext.getAllStructuralFeatures(metaclass.getUid().longValue());
            ArrayList<Object> objects = new ArrayList<Object>();
            for (WidgetMapping next : widgetMappings) {
                MStructuralFeatureDTO sf = (MStructuralFeatureDTO)structuralFeatures.get(next.name());
                if (sf != null) {
                    objects.add(sf);
                    continue;
                }
                LOG.warn(String.format("Invalid mapping for structural feature %s on meta-class %s", next.name(), metaclass.getName()));
            }
            return objects;
        }
        return List.of();
    }

    private List<Object> getDefaultStructuralFeatures(VariableManager variableManager) {
        Object self = variableManager.getVariables().get("self");
        if (self instanceof ModelObjectNode) {
            ModelObjectNode node = (ModelObjectNode)self;
            IModelContext modelContext = (IModelContext)this.modelContextProvider.apply(node.getModelId());
            return modelContext.getAllStructuralFeatures(node.getMetaclassId()).values().stream().filter(arg_0 -> this.includeInDefaultProperties(arg_0)).map(Object.class::cast).toList();
        }
        return List.of();
    }

    private List<Object> getDefaultStructuralFeaturesInSnapshot(VariableManager variableManager) {
        Optional optSelf = variableManager.get("self", ModelObjectSnapshotNode.class);
        Optional optModelSnapshot = variableManager.get(VAR_MODEL_SNAPSHOT, ModelSnapshot.class);
        Optional optSnapshotContext = variableManager.get(VAR_MODEL_SNAPSHOT_CONTEXT, ModelSnapshotContext.class);
        if (optSelf.isPresent() && optModelSnapshot.isPresent() && optSnapshotContext.isPresent()) {
            ModelObjectSnapshotNode self = (ModelObjectSnapshotNode)optSelf.get();
            ModelSnapshot modelSnapshot = (ModelSnapshot)optModelSnapshot.get();
            ModelSnapshotContext snapshotContext = (ModelSnapshotContext)optSnapshotContext.get();
            MetaclassQName mcQName = self.snapshot().getIntrinsic().getMetaclass();
            MetaclassDTO metaclass = this.getMetaclass(modelSnapshot, mcQName);
            return snapshotContext.getAllStructuralFeatures(metaclass.getUid().longValue()).values().stream().filter(arg_0 -> this.includeInDefaultProperties(arg_0)).map(Object.class::cast).toList();
        }
        return List.of();
    }

    private boolean includeInDefaultProperties(MStructuralFeatureDTO sf) {
        return !"name".equals(sf.getName()) && !"id".equals(sf.getName()) && !"description".equals(sf.getName());
    }
}

