/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.properties;

import fr.obeo.perseus.server.IModelObject;
import fr.obeo.perseus.server.ModelObjectID;
import fr.obeo.perseus.server.app.properties.WidgetMapping;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.dto.PName;
import fr.obeo.perseus.server.dto.meta.MAttributeDTO;
import fr.obeo.perseus.server.dto.meta.MClassifierDTO;
import fr.obeo.perseus.server.dto.meta.MEnumDTO;
import fr.obeo.perseus.server.dto.meta.MEnumLiteralDTO;
import fr.obeo.perseus.server.dto.meta.MReferenceDTO;
import fr.obeo.perseus.server.dto.meta.MStructuralFeatureDTO;
import fr.obeo.perseus.server.infra.entities.ModelObject;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.IModelContext;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.forms.ListStyle;
import org.eclipse.sirius.components.forms.description.AbstractControlDescription;
import org.eclipse.sirius.components.forms.description.CheckboxDescription;
import org.eclipse.sirius.components.forms.description.IfDescription;
import org.eclipse.sirius.components.forms.description.ListDescription;
import org.eclipse.sirius.components.forms.description.RadioDescription;
import org.eclipse.sirius.components.forms.description.TextfieldDescription;
import org.eclipse.sirius.components.representations.Failure;
import org.eclipse.sirius.components.representations.Success;
import org.eclipse.sirius.components.representations.VariableManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Component;

@Component
public class ModelObjectNodeStructuralFeaturesIfDescriptionProvider {
    private static final String CURRENT_MO_PROPS = "currentMOProps";
    private static final String TEXTFIELD_DESCRIPTION_ID = "Textfield";
    private static final String CURRENT_MO_REFS = "currentMORefs";
    private static final String LIST_DESCRIPTION_ID = "List";
    private final IModelObjectRepository modelObjectRepo;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final IIdentityService identityService;
    private final IIconService iconService;
    private final Function<VariableManager, String> semanticTargetIdProvider;

    public ModelObjectNodeStructuralFeaturesIfDescriptionProvider(IModelObjectRepository modelObjectRepo, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IIconService iconService, IIdentityService identityService) {
        this.modelObjectRepo = Objects.requireNonNull(modelObjectRepo);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.iconService = Objects.requireNonNull(iconService);
        this.identityService = Objects.requireNonNull(identityService);
        this.semanticTargetIdProvider = variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElse(null);
    }

    public List<AbstractControlDescription> getIfDescriptions() {
        return List.of(IfDescription.newIfDescription((String)"IfText").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isTextAttribute(arg_0)).controlDescriptions(Collections.singletonList(this.getTextfieldDescription())).build(), IfDescription.newIfDescription((String)"IfBoolean").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isBooleanAttribute(arg_0)).controlDescriptions(Collections.singletonList(this.getCheckboxDescription())).build(), IfDescription.newIfDescription((String)"IfEnum").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isEnumAttribute(arg_0)).controlDescriptions(Collections.singletonList(this.getRadioDescription())).build(), IfDescription.newIfDescription((String)"IfMReference").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isModelObjectMReference(arg_0)).controlDescriptions(Collections.singletonList(this.getListDescription())).build());
    }

    private boolean isTextAttribute(VariableManager variableManager) {
        return !this.isEnumAttribute(variableManager) && variableManager.get("structuralFeature", MAttributeDTO.class).map(att -> !this.isBoolean(att)).orElse(false) != false;
    }

    private boolean isBooleanAttribute(VariableManager variableManager) {
        return variableManager.get("structuralFeature", MAttributeDTO.class).map(att -> this.isBoolean(att)).orElse(false);
    }

    private boolean isEnumAttribute(VariableManager variableManager) {
        return variableManager.get("structuralFeature", MAttributeDTO.class).map(att -> {
            boolean isEnum = variableManager.get("modelContext", IModelContext.class).map(modelContext -> {
                MClassifierDTO attType = modelContext.resolve(att.getType()).orElse(null);
                return attType instanceof MEnumDTO;
            }).orElse(false);
            return isEnum;
        }).orElse(false);
    }

    private boolean isBoolean(MAttributeDTO att) {
        return att.getType().getName().equals("Boolean") || att.getType().getName().equals("EBoolean");
    }

    private TextfieldDescription getTextfieldDescription() {
        return TextfieldDescription.newTextfieldDescription((String)TEXTFIELD_DESCRIPTION_ID).diagnosticsProvider(vm -> Collections.emptyList()).helpTextProvider(arg_0 -> this.getSFDescription(arg_0)).idProvider(arg_0 -> this.getId(arg_0)).isReadOnlyProvider(vm -> true).kindProvider(o -> "").labelProvider(arg_0 -> this.getLabel(arg_0)).messageProvider(o -> "").newValueHandler((vm, newValue) -> new Failure(this.modelAppMessageSourceAccessor.getMessage("props.update.msg"))).targetObjectIdProvider(this.semanticTargetIdProvider).valueProvider(arg_0 -> this.getValue(arg_0)).build();
    }

    private RadioDescription getRadioDescription() {
        return RadioDescription.newRadioDescription((String)"Radio").diagnosticsProvider(vm -> Collections.emptyList()).helpTextProvider(arg_0 -> this.getSFDescription(arg_0)).idProvider(arg_0 -> this.getId(arg_0)).isReadOnlyProvider(vm -> true).kindProvider(o -> "").labelProvider(arg_0 -> this.getLabel(arg_0)).messageProvider(o -> "").newValueHandler((vm, newValue) -> new Failure(this.modelAppMessageSourceAccessor.getMessage("props.update.msg"))).optionIdProvider(vm -> ((MEnumLiteralDTO)vm.get("candidate", MEnumLiteralDTO.class).get()).getLiteral()).optionLabelProvider(vm -> ((MEnumLiteralDTO)vm.get("candidate", MEnumLiteralDTO.class).get()).getLiteral()).optionSelectedProvider(vm -> {
            String value = this.getValue(vm);
            MEnumLiteralDTO enumLiteralDTO = (MEnumLiteralDTO)vm.get("candidate", MEnumLiteralDTO.class).get();
            return value.equals(enumLiteralDTO.getLiteral());
        }).optionsProvider(vm -> {
            PName attTypePName = vm.get("structuralFeature", MAttributeDTO.class).map(att -> att.getType()).get();
            return vm.get("modelContext", IModelContext.class).flatMap(modelContext -> modelContext.resolve(attTypePName)).map(enumDto -> ((MEnumDTO)enumDto).getLiterals()).orElse(List.of());
        }).targetObjectIdProvider(this.semanticTargetIdProvider).build();
    }

    private CheckboxDescription getCheckboxDescription() {
        return CheckboxDescription.newCheckboxDescription((String)"Checkbox").diagnosticsProvider(vm -> Collections.emptyList()).helpTextProvider(arg_0 -> this.getSFDescription(arg_0)).idProvider(arg_0 -> this.getId(arg_0)).isReadOnlyProvider(vm -> true).kindProvider(o -> "").labelProvider(arg_0 -> this.getLabel(arg_0)).messageProvider(o -> "").newValueHandler((vm, newValue) -> new Failure(this.modelAppMessageSourceAccessor.getMessage("props.update.msg"))).targetObjectIdProvider(this.semanticTargetIdProvider).valueProvider(vm -> Boolean.parseBoolean(this.getValue(vm))).build();
    }

    private String getId(VariableManager variableManager) {
        Optional optionalNode = variableManager.get("self", ModelObjectNode.class);
        Optional optionalAtt = variableManager.get("structuralFeature", MStructuralFeatureDTO.class);
        if (optionalNode.isPresent() && optionalAtt.isPresent()) {
            return ((ModelObjectNode)optionalNode.get()).getId() + "#" + Long.toString(((MStructuralFeatureDTO)optionalAtt.get()).getUid());
        }
        return "";
    }

    private String getLabel(VariableManager variableManager) {
        Optional optWidgetMappings = variableManager.get("widgetMappings", List.class);
        return variableManager.get("structuralFeature", MStructuralFeatureDTO.class).map(sf -> sf.getName()).map(sfName -> {
            if (optWidgetMappings.isPresent()) {
                List widgetMappings = (List)optWidgetMappings.get();
                return widgetMappings.stream().filter(wm -> sfName.equals(wm.name())).findFirst().map(WidgetMapping::label).orElse((String)sfName);
            }
            return sfName;
        }).orElse("");
    }

    private String getSFDescription(VariableManager variableManager) {
        return variableManager.get("structuralFeature", MStructuralFeatureDTO.class).map(sf -> sf.getDescription()).orElse("");
    }

    private String getValue(VariableManager variableManager) {
        Optional optionalObject = variableManager.get("self", ModelObjectNode.class);
        Optional optionalAttribute = variableManager.get("structuralFeature", MAttributeDTO.class);
        if (optionalObject.isPresent() && optionalAttribute.isPresent()) {
            ModelObjectNode node = (ModelObjectNode)optionalObject.get();
            MAttributeDTO attribute = (MAttributeDTO)optionalAttribute.get();
            if ("name".equals(attribute.getName())) {
                return node.getLabel();
            }
            if ("id".equals(attribute.getName())) {
                return node.getId();
            }
            Map props = variableManager.get(CURRENT_MO_PROPS, Map.class).orElseGet(() -> {
                Optional optMO = this.modelObjectRepo.findById((Object)new ModelObjectID(node.getModelId(), node.getId()));
                return optMO.map(mo -> {
                    Map result = Optional.ofNullable(mo.getJsonProps()).orElseGet(Collections::emptyMap);
                    variableManager.put(CURRENT_MO_PROPS, (Object)result);
                    return result;
                }).orElseGet(() -> {
                    variableManager.put(CURRENT_MO_PROPS, Collections.emptyMap());
                    return Collections.emptyMap();
                });
            });
            return Optional.ofNullable(props.get(attribute.getName())).map(Object::toString).orElse("");
        }
        return "";
    }

    private boolean isModelObjectMReference(VariableManager variableManager) {
        return variableManager.get("structuralFeature", MReferenceDTO.class).isPresent() && variableManager.get("self", ModelObjectNode.class).isPresent();
    }

    private ListDescription getListDescription() {
        return ListDescription.newListDescription((String)LIST_DESCRIPTION_ID).diagnosticsProvider(vm -> Collections.emptyList()).helpTextProvider(arg_0 -> this.getSFDescription(arg_0)).iconURLProvider(vm -> List.of()).idProvider(arg_0 -> this.getId(arg_0)).isReadOnlyProvider(vm -> true).itemClickHandlerProvider(vm -> new Success()).itemDeletableProvider(vm -> false).itemDeleteHandlerProvider(vm -> new Success()).itemIconURLProvider(arg_0 -> this.getItemIconURL(arg_0)).itemIdProvider(arg_0 -> this.getItemId(arg_0)).itemKindProvider(arg_0 -> this.getItemKind(arg_0)).itemLabelProvider(arg_0 -> this.getItemLabel(arg_0)).itemsProvider(arg_0 -> this.getReferencedElements(arg_0)).kindProvider(o -> "").labelProvider(arg_0 -> this.getLabel(arg_0)).messageProvider(o -> "").styleProvider(vm -> ListStyle.newListStyle().build()).targetObjectIdProvider(this.semanticTargetIdProvider).build();
    }

    private List<? extends Object> getReferencedElements(VariableManager variableManager) {
        Optional optionalObject = variableManager.get("self", ModelObjectNode.class);
        Optional optRef = variableManager.get("structuralFeature", MReferenceDTO.class);
        if (optionalObject.isPresent() && optRef.isPresent()) {
            ModelObjectNode node = (ModelObjectNode)optionalObject.get();
            MReferenceDTO ref = (MReferenceDTO)optRef.get();
            Map refs = variableManager.get(CURRENT_MO_REFS, Map.class).orElseGet(() -> {
                Optional optMO = this.modelObjectRepo.findById((Object)new ModelObjectID(node.getModelId(), node.getId()));
                return optMO.map(mo -> {
                    Map result = Optional.ofNullable(mo.getOutgoing()).orElseGet(Collections::emptyMap);
                    variableManager.put(CURRENT_MO_REFS, (Object)result);
                    return result;
                }).orElseGet(() -> {
                    variableManager.put(CURRENT_MO_REFS, Collections.emptyMap());
                    return Collections.emptyMap();
                });
            });
            return Optional.ofNullable(refs.get(ref.getName())).map(idList -> {
                if (idList instanceof String) {
                    return this.modelObjectRepo.loadModelObjectSummariesByUids(node.getModelId(), List.of((String)idList), false);
                }
                if (idList instanceof List) {
                    List unsortedList = this.modelObjectRepo.loadModelObjectSummariesByUids(node.getModelId(), (List)idList, false);
                    Map<String, IModelObject> modelObjectsByUid = unsortedList.stream().collect(Collectors.toMap(mo -> mo.getUid(), mo -> mo));
                    return ((List)idList).stream().map(uid -> Optional.ofNullable((IModelObject)modelObjectsByUid.get(uid)).orElseGet(() -> {
                        ModelObject unknownMO = new ModelObject(false);
                        unknownMO.setUid(uid);
                        return unknownMO;
                    })).toList();
                }
                return List.of();
            }).orElse(List.of());
        }
        return List.of();
    }

    private String getItemLabel(VariableManager variableManager) {
        return variableManager.get("candidate", IModelObject.class).map(IModelObject::getName).orElse("");
    }

    private List<String> getItemIconURL(VariableManager variableManager) {
        return variableManager.get("candidate", IModelObject.class).map(mo -> this.iconService.getIconPath(mo.getIconHash(), mo.getMetaclassUid())).map(List::of).orElse(List.of());
    }

    private String getItemId(VariableManager variableManager) {
        return variableManager.get("candidate", IModelObject.class).map(mo -> PerseusRepresentationUtils.toModelObjectRepId((long)mo.getModelUid(), (String)mo.getUid())).orElse("");
    }

    private String getItemKind(VariableManager variableManager) {
        return "ModelObject";
    }
}

