/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.properties;

import fr.obeo.perseus.server.app.properties.WidgetMapping;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.dto.PName;
import fr.obeo.perseus.server.dto.meta.MAttributeDTO;
import fr.obeo.perseus.server.dto.meta.MClassifierDTO;
import fr.obeo.perseus.server.dto.meta.MEnumDTO;
import fr.obeo.perseus.server.dto.meta.MEnumLiteralDTO;
import fr.obeo.perseus.server.dto.meta.MReferenceDTO;
import fr.obeo.perseus.server.dto.meta.MStructuralFeatureDTO;
import fr.obeo.perseus.server.dto.meta.MetaclassDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.model.domain.mappings.ModelSnapshotContext;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.dto.versioning.AbstractModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.DerivedModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.IntrinsicModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshot;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import fr.obeo.perseus.server.versioning.ICommit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.forms.ListStyle;
import org.eclipse.sirius.components.forms.description.AbstractControlDescription;
import org.eclipse.sirius.components.forms.description.CheckboxDescription;
import org.eclipse.sirius.components.forms.description.IfDescription;
import org.eclipse.sirius.components.forms.description.ListDescription;
import org.eclipse.sirius.components.forms.description.RadioDescription;
import org.eclipse.sirius.components.forms.description.TextfieldDescription;
import org.eclipse.sirius.components.representations.Failure;
import org.eclipse.sirius.components.representations.Success;
import org.eclipse.sirius.components.representations.VariableManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Component;

@Component
public class ModelObjectSnapshotStructuralFeaturesIfDescriptionProvider {
    private static final String TEXTFIELD_DESCRIPTION_ID = "Textfield";
    private static final String LIST_DESCRIPTION_ID = "List";
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final IIdentityService identityService;
    private final IIconService iconService;
    private final Function<VariableManager, String> semanticTargetIdProvider;

    public ModelObjectSnapshotStructuralFeaturesIfDescriptionProvider(IModelObjectSnapshotSearchService modelObjectSnapshotSearchService, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IIconService iconService, IIdentityService identityService) {
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.iconService = Objects.requireNonNull(iconService);
        this.identityService = Objects.requireNonNull(identityService);
        this.semanticTargetIdProvider = variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElse(null);
    }

    public List<AbstractControlDescription> getIfDescriptions() {
        return List.of(IfDescription.newIfDescription((String)"IfText").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isTextAttribute(arg_0)).controlDescriptions(Collections.singletonList(this.getTextfieldDescription())).build(), IfDescription.newIfDescription((String)"IfBoolean").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isBooleanAttribute(arg_0)).controlDescriptions(Collections.singletonList(this.getCheckboxDescription())).build(), IfDescription.newIfDescription((String)"IfEnum").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isEnumAttribute(arg_0)).controlDescriptions(Collections.singletonList(this.getRadioDescription())).build(), IfDescription.newIfDescription((String)"IfMReference").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isModelObjectMReference(arg_0)).controlDescriptions(Collections.singletonList(this.getListDescription())).build());
    }

    private boolean isTextAttribute(VariableManager variableManager) {
        boolean result = !this.isEnumAttribute(variableManager) && variableManager.get("structuralFeature", MAttributeDTO.class).map(att -> !this.isBoolean(att)).orElse(false) != false;
        return result;
    }

    private boolean isBooleanAttribute(VariableManager variableManager) {
        boolean result = variableManager.get("structuralFeature", MAttributeDTO.class).map(arg_0 -> this.isBoolean(arg_0)).orElse(false);
        return result;
    }

    private boolean isEnumAttribute(VariableManager variableManager) {
        boolean result = variableManager.get("structuralFeature", MAttributeDTO.class).map(att -> {
            boolean isEnum = variableManager.get("modelSnapshotContext", ModelSnapshotContext.class).map(modelContext -> {
                MClassifierDTO attType = modelContext.resolve(att.getType()).orElse(null);
                return attType instanceof MEnumDTO;
            }).orElse(false);
            return isEnum;
        }).orElse(false);
        return result;
    }

    private boolean isBoolean(MAttributeDTO att) {
        return att.getType().getName().equals("Boolean") || att.getType().getName().equals("EBoolean");
    }

    private TextfieldDescription getTextfieldDescription() {
        return TextfieldDescription.newTextfieldDescription((String)TEXTFIELD_DESCRIPTION_ID).diagnosticsProvider(vm -> Collections.emptyList()).helpTextProvider(arg_0 -> this.getSFDescription(arg_0)).idProvider(arg_0 -> this.getId(arg_0)).isReadOnlyProvider(vm -> true).kindProvider(o -> "").labelProvider(arg_0 -> this.getLabel(arg_0)).messageProvider(o -> "").newValueHandler((vm, newValue) -> new Failure(this.modelAppMessageSourceAccessor.getMessage("props.update.msg"))).targetObjectIdProvider(this.semanticTargetIdProvider).valueProvider(arg_0 -> this.getValue(arg_0)).build();
    }

    private RadioDescription getRadioDescription() {
        return RadioDescription.newRadioDescription((String)"Radio").diagnosticsProvider(vm -> Collections.emptyList()).helpTextProvider(arg_0 -> this.getSFDescription(arg_0)).idProvider(arg_0 -> this.getId(arg_0)).isReadOnlyProvider(vm -> true).kindProvider(o -> "").labelProvider(arg_0 -> this.getLabel(arg_0)).messageProvider(o -> "").newValueHandler((vm, newValue) -> new Failure(this.modelAppMessageSourceAccessor.getMessage("props.update.msg"))).optionIdProvider(vm -> ((MEnumLiteralDTO)vm.get("candidate", MEnumLiteralDTO.class).get()).getLiteral()).optionLabelProvider(vm -> ((MEnumLiteralDTO)vm.get("candidate", MEnumLiteralDTO.class).get()).getLiteral()).optionSelectedProvider(vm -> {
            String value = this.getValue(vm);
            MEnumLiteralDTO enumLiteralDTO = (MEnumLiteralDTO)vm.get("candidate", MEnumLiteralDTO.class).get();
            return value.equals(enumLiteralDTO.getLiteral());
        }).optionsProvider(vm -> {
            PName attTypePName = vm.get("structuralFeature", MAttributeDTO.class).map(att -> att.getType()).get();
            return vm.get("modelSnapshotContext", ModelSnapshotContext.class).flatMap(modelContext -> modelContext.resolve(attTypePName)).map(enumDto -> ((MEnumDTO)enumDto).getLiterals()).orElse(List.of());
        }).targetObjectIdProvider(this.semanticTargetIdProvider).build();
    }

    private CheckboxDescription getCheckboxDescription() {
        return CheckboxDescription.newCheckboxDescription((String)"Checkbox").diagnosticsProvider(vm -> Collections.emptyList()).helpTextProvider(arg_0 -> this.getSFDescription(arg_0)).idProvider(arg_0 -> this.getId(arg_0)).isReadOnlyProvider(vm -> true).kindProvider(o -> "").labelProvider(arg_0 -> this.getLabel(arg_0)).messageProvider(o -> "").newValueHandler((vm, newValue) -> new Failure(this.modelAppMessageSourceAccessor.getMessage("props.update.msg"))).targetObjectIdProvider(this.semanticTargetIdProvider).valueProvider(vm -> Boolean.parseBoolean(this.getValue(vm))).build();
    }

    private String getId(VariableManager variableManager) {
        Optional optionalNode = variableManager.get("self", ModelObjectSnapshotNode.class);
        Optional optionalAtt = variableManager.get("structuralFeature", MStructuralFeatureDTO.class);
        if (optionalNode.isPresent() && optionalAtt.isPresent()) {
            return ((ModelObjectSnapshotNode)optionalNode.get()).objectId() + "#" + Long.toString(((MStructuralFeatureDTO)optionalAtt.get()).getUid());
        }
        return "";
    }

    private String getLabel(VariableManager variableManager) {
        Optional optWidgetMappings = variableManager.get("widgetMappings", List.class);
        return variableManager.get("structuralFeature", MStructuralFeatureDTO.class).map(sf -> sf.getName()).map(sfName -> {
            if (optWidgetMappings.isPresent()) {
                List widgetMappings = (List)optWidgetMappings.get();
                return widgetMappings.stream().filter(wm -> sfName.equals(wm.name())).findFirst().map(WidgetMapping::label).orElse((String)sfName);
            }
            return sfName;
        }).orElse("");
    }

    private String getSFDescription(VariableManager variableManager) {
        return variableManager.get("structuralFeature", MStructuralFeatureDTO.class).map(sf -> sf.getDescription()).orElse("");
    }

    private String getValue(VariableManager variableManager) {
        Optional optionalObject = variableManager.get("self", ModelObjectSnapshotNode.class);
        Optional optionalAttribute = variableManager.get("structuralFeature", MAttributeDTO.class);
        if (optionalObject.isPresent() && optionalAttribute.isPresent()) {
            ModelObjectSnapshotNode snapshot = (ModelObjectSnapshotNode)optionalObject.get();
            MAttributeDTO attribute = (MAttributeDTO)optionalAttribute.get();
            IntrinsicModelObjectData intrinsic = snapshot.snapshot().getIntrinsic();
            Optional<DerivedModelObjectData> optDerived = Optional.ofNullable(snapshot.snapshot().getDerived());
            String attName = attribute.getName();
            if ("name".equals(attName)) {
                return optDerived.map(DerivedModelObjectData::getTitle).orElse("");
            }
            if ("id".equals(attName)) {
                return snapshot.objectId();
            }
            return Optional.ofNullable(intrinsic.getStructuralFeatureSettings().get(attName)).or(() -> optDerived.map(AbstractModelObjectData::getStructuralFeatureSettings).map(m -> m.get(attName))).map(Object::toString).orElse("");
        }
        return "";
    }

    private boolean isModelObjectMReference(VariableManager variableManager) {
        return variableManager.get("structuralFeature", MReferenceDTO.class).isPresent() && variableManager.get("self", ModelObjectSnapshotNode.class).isPresent();
    }

    private ListDescription getListDescription() {
        return ListDescription.newListDescription((String)LIST_DESCRIPTION_ID).diagnosticsProvider(vm -> Collections.emptyList()).helpTextProvider(arg_0 -> this.getSFDescription(arg_0)).iconURLProvider(vm -> List.of()).idProvider(arg_0 -> this.getId(arg_0)).isReadOnlyProvider(vm -> true).itemClickHandlerProvider(vm -> new Success()).itemDeletableProvider(vm -> false).itemDeleteHandlerProvider(vm -> new Success()).itemIconURLProvider(arg_0 -> this.getItemIconURL(arg_0)).itemIdProvider(arg_0 -> this.getItemId(arg_0)).itemKindProvider(arg_0 -> this.getItemKind(arg_0)).itemLabelProvider(arg_0 -> this.getItemLabel(arg_0)).itemsProvider(arg_0 -> this.getReferencedElements(arg_0)).kindProvider(o -> "").labelProvider(arg_0 -> this.getLabel(arg_0)).messageProvider(o -> "").styleProvider(vm -> ListStyle.newListStyle().build()).targetObjectIdProvider(this.semanticTargetIdProvider).build();
    }

    private List<? extends Object> getReferencedElements(VariableManager variableManager) {
        Optional optionalObject = variableManager.get("self", ModelObjectSnapshotNode.class);
        Optional optRef = variableManager.get("structuralFeature", MReferenceDTO.class);
        Optional optCommit = variableManager.get("commit", ICommit.class);
        if (optionalObject.isPresent() && optRef.isPresent() && optCommit.isPresent()) {
            ModelObjectSnapshotNode imos = (ModelObjectSnapshotNode)optionalObject.get();
            MReferenceDTO ref = (MReferenceDTO)optRef.get();
            ICommit commit = (ICommit)optCommit.get();
            IntrinsicModelObjectData intrinsic = imos.snapshot().getIntrinsic();
            Optional<DerivedModelObjectData> optDerived = Optional.ofNullable(imos.snapshot().getDerived());
            String refName = ref.getName();
            return Optional.ofNullable(intrinsic.getStructuralFeatureSettings().get(refName)).or(() -> optDerived.map(AbstractModelObjectData::getStructuralFeatureSettings).map(m -> m.get(refName))).map(idList -> {
                List<Object> moidList;
                if (idList instanceof String) {
                    String objId2 = (String)idList;
                    IModelObjectID moId = imos.model().id().forObject(objId2);
                    moidList = List.of(moId);
                } else {
                    moidList = idList instanceof List ? ((List)idList).stream().map(objId -> imos.model().id().forObject(String.valueOf(objId))).toList() : List.of();
                }
                Map<String, ModelObjectSnapshotNode> nodesByUid = this.modelObjectSnapshotSearchService.findModelObjectsInCommit(moidList, commit).entrySet().stream().collect(Collectors.toMap(e -> ((IModelObjectID)e.getKey()).getObjectId(), e -> new ModelObjectSnapshotNode(imos.model(), ((IModelObjectID)e.getKey()).getObjectId(), (ModelObjectSnapshot)e.getValue())));
                if (idList instanceof String) {
                    String uid2 = (String)idList;
                    return List.of(Optional.ofNullable(nodesByUid.get(uid2)).orElseGet(() -> {
                        ModelObjectSnapshotNode unknownMO = new ModelObjectSnapshotNode(imos.model(), String.valueOf(uid2), new ModelObjectSnapshot());
                        IntrinsicModelObjectData unknownIntrinsic = new IntrinsicModelObjectData();
                        unknownIntrinsic.setMetaclass(MetaclassQName.forString((String)MetaclassDTO.unknown().getURI().toString()));
                        unknownMO.snapshot().setIntrinsic(unknownIntrinsic);
                        return unknownMO;
                    }));
                }
                return ((List)idList).stream().map(uid -> Optional.ofNullable((ModelObjectSnapshotNode)nodesByUid.get(uid)).orElseGet(() -> {
                    ModelObjectSnapshotNode unknownMO = new ModelObjectSnapshotNode(imos.model(), String.valueOf(uid), new ModelObjectSnapshot());
                    IntrinsicModelObjectData unknownIntrinsic = new IntrinsicModelObjectData();
                    unknownIntrinsic.setMetaclass(MetaclassQName.forString((String)MetaclassDTO.unknown().getURI().toString()));
                    unknownMO.snapshot().setIntrinsic(unknownIntrinsic);
                    return unknownMO;
                })).toList();
            }).orElse(List.of());
        }
        return List.of();
    }

    private String getItemLabel(VariableManager variableManager) {
        return variableManager.get("candidate", ModelObjectSnapshotNode.class).map(imos -> Optional.ofNullable(imos.snapshot().getDerived()).map(DerivedModelObjectData::getTitle).orElse("")).orElse("");
    }

    private List<String> getItemIconURL(VariableManager vm) {
        return vm.get("modelSnapshotContext", ModelSnapshotContext.class).flatMap(context -> vm.get("candidate", ModelObjectSnapshotNode.class).flatMap(imos -> context.resolve(imos.snapshot().getIntrinsic().getMetaclass()).map(mcDTO -> this.iconService.getIconPath((String)Optional.ofNullable(imos.snapshot().getDerived()).map(DerivedModelObjectData::getIconHash).orElse(null), mcDTO.getUid().longValue())))).map(List::of).orElse(List.of());
    }

    private String getItemId(VariableManager variableManager) {
        return variableManager.get("candidate", ModelObjectSnapshotNode.class).map(imos -> PerseusRepresentationUtils.toModelObjectRepId((long)imos.model().id().getModelId(), (String)imos.objectId())).orElse("");
    }

    private String getItemKind(VariableManager variableManager) {
        return "ModelObject";
    }
}

