/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.properties;

import fr.obeo.perseus.server.app.properties.ObjectFormMapping;
import fr.obeo.perseus.server.app.properties.WidgetMapping;
import fr.obeo.perseus.server.dto.meta.MetaclassDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PropertyMappingsDefinition {
    private Map<String, Map<String, List<WidgetMapping>>> propertyMappings;
    private Map<String, Map<String, ObjectFormMapping>> objectFormMappings;

    protected Map<String, Map<String, ObjectFormMapping>> getObjectFormMappings() {
        return this.objectFormMappings;
    }

    protected void setObjectFormMappings(Map<String, Map<String, ObjectFormMapping>> objectFormMappings) {
        this.objectFormMappings = objectFormMappings;
    }

    protected Map<String, Map<String, List<WidgetMapping>>> getPropertyMappings() {
        return this.propertyMappings;
    }

    protected void setPropertyMappings(Map<String, Map<String, List<WidgetMapping>>> propertyMappings) {
        this.propertyMappings = propertyMappings;
    }

    public List<WidgetMapping> getMappings(MetaclassDTO metaclass) {
        String nsURI = metaclass.getMetamodelURI().toString();
        HashMap mergedMap = null;
        boolean needsMerge = false;
        for (Map.Entry entry : this.propertyMappings.entrySet()) {
            if (!nsURI.contains((CharSequence)entry.getKey())) continue;
            if (mergedMap == null) {
                mergedMap = (HashMap)entry.getValue();
                needsMerge = true;
                continue;
            }
            if (needsMerge) {
                mergedMap = new HashMap(mergedMap);
                needsMerge = false;
            }
            mergedMap.putAll((Map)entry.getValue());
        }
        return Optional.ofNullable(mergedMap).map(m -> (List)m.get(metaclass.getName())).orElse(List.of());
    }

    public Optional<ObjectFormMapping> getObjectFormMapping(MetaclassDTO metaclass) {
        String nsURI = metaclass.getMetamodelURI().toString();
        HashMap mergedMap = null;
        boolean needsMerge = false;
        for (Map.Entry entry : this.objectFormMappings.entrySet()) {
            if (!nsURI.contains((CharSequence)entry.getKey())) continue;
            if (mergedMap == null) {
                mergedMap = (HashMap)entry.getValue();
                needsMerge = true;
                continue;
            }
            if (needsMerge) {
                mergedMap = new HashMap(mergedMap);
                needsMerge = false;
            }
            mergedMap.putAll((Map)entry.getValue());
        }
        return Optional.ofNullable(mergedMap).map(m -> (ObjectFormMapping)m.get(metaclass.getName()));
    }

    public Optional<ObjectFormMapping> getObjectFormMapping(MetaclassQName metaclassQName) {
        String nsURI = metaclassQName.nsUri();
        HashMap mergedMap = null;
        boolean needsMerge = false;
        for (Map.Entry entry : this.objectFormMappings.entrySet()) {
            if (!nsURI.contains((CharSequence)entry.getKey())) continue;
            if (mergedMap == null) {
                mergedMap = (HashMap)entry.getValue();
                needsMerge = true;
                continue;
            }
            if (needsMerge) {
                mergedMap = new HashMap(mergedMap);
                needsMerge = false;
            }
            mergedMap.putAll((Map)entry.getValue());
        }
        return Optional.ofNullable(mergedMap).map(m -> (ObjectFormMapping)m.get(metaclassQName.name()));
    }

    public boolean hasMapping(MetaclassDTO metaclass) {
        String nsURI = metaclass.getMetamodelURI().toString();
        for (Map.Entry entry : this.propertyMappings.entrySet()) {
            if (!nsURI.contains((CharSequence)entry.getKey()) || !((Map)entry.getValue()).containsKey(metaclass.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasMapping(MetaclassQName metaclassQName) {
        String nsURI = metaclassQName.nsUri();
        for (Map.Entry entry : this.propertyMappings.entrySet()) {
            if (!nsURI.contains((CharSequence)entry.getKey()) || !((Map)entry.getValue()).containsKey(metaclassQName.name())) continue;
            return true;
        }
        return false;
    }

    public boolean hasObjectFormMapping(MetaclassDTO metaclass) {
        String nsURI = metaclass.getMetamodelURI().toString();
        for (Map.Entry entry : this.objectFormMappings.entrySet()) {
            if (!nsURI.contains((CharSequence)entry.getKey()) || !((Map)entry.getValue()).containsKey(metaclass.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasObjectFormMapping(MetaclassQName metaclassQName) {
        String nsURI = metaclassQName.nsUri();
        for (Map.Entry entry : this.objectFormMappings.entrySet()) {
            if (!nsURI.contains((CharSequence)entry.getKey()) || !((Map)entry.getValue()).containsKey(metaclassQName.name())) continue;
            return true;
        }
        return false;
    }
}

