/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.services.IModelObjectCommitSearchApplicationService;
import fr.obeo.perseus.server.app.services.ModelObjectCommitSearchApplicationService;
import fr.obeo.perseus.server.services.api.dto.versioning.DerivedModelObjectData;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import fr.obeo.perseus.server.versioning.IBranch;
import fr.obeo.perseus.server.versioning.ICommit;
import fr.obeo.perseus.server.versioning.IHistory;
import fr.obeo.perseus.server.versioning.api.IBranchSearchService;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ModelObjectCommitSearchApplicationService
implements IModelObjectCommitSearchApplicationService {
    private final IBranchSearchService branchSearchService;
    private final ICommitSearchService commitSearchService;
    private final IModelObjectSnapshotSearchService moSnapshotSearchService;
    private final CommitVersionComparator commitVersionComparator;

    public ModelObjectCommitSearchApplicationService(IBranchSearchService branchSearchService, ICommitSearchService commitSearchService, IModelObjectSnapshotSearchService moSnapshotSearchService, CommitVersionComparator commitVersionComparator) {
        this.branchSearchService = Objects.requireNonNull(branchSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.moSnapshotSearchService = Objects.requireNonNull(moSnapshotSearchService);
        this.commitVersionComparator = Objects.requireNonNull(commitVersionComparator);
    }

    public List<ICommit> getModelObjectCommits(IHistory history, IModelObjectID moId, Optional<Integer> maxVersion, int limit) {
        IBranch branch = (IBranch)this.branchSearchService.findBranchesByTitle(history, "Master").get(0);
        Optional optSnapshot = this.moSnapshotSearchService.findLatestModelObjectNonDeletedSnapshot(branch, moId);
        return optSnapshot.map(snapshot -> {
            List otherCommits;
            List objectCommits = this.commitSearchService.getCommits(history, moId.getObjectId(), maxVersion, limit).stream().toList();
            if (snapshot.getIntrinsic().getMetaclass().isRepresentationDescriptor()) {
                String reprId = (String)snapshot.getIntrinsic().getStructuralFeatureSettings().get("representation");
                otherCommits = this.commitSearchService.getCommits(history, reprId, maxVersion, limit).stream().toList();
            } else {
                otherCommits = snapshot.getIntrinsic().getMetaclass().isRepresentation() ? Optional.ofNullable(snapshot.getDerived()).flatMap(DerivedModelObjectData::getParentId).map(descId -> this.commitSearchService.getCommits(history, descId, maxVersion, limit).stream().toList()).orElseGet(List::of) : List.of();
            }
            if (otherCommits.isEmpty()) {
                return objectCommits.stream().toList();
            }
            ArrayList<ICommit> result = new ArrayList<ICommit>(limit);
            int objectIndex = 0;
            int otherIndex = 0;
            for (int i = 0; i < limit; ++i) {
                if (objectCommits.size() > objectIndex) {
                    if (otherCommits.size() > otherIndex) {
                        int comp = this.commitVersionComparator.compare((ICommit)objectCommits.get(objectIndex), (ICommit)otherCommits.get(otherIndex));
                        if (comp > 0) {
                            result.add((ICommit)objectCommits.get(objectIndex++));
                            continue;
                        }
                        if (comp < 0) {
                            result.add((ICommit)otherCommits.get(otherIndex++));
                            continue;
                        }
                        result.add((ICommit)objectCommits.get(objectIndex++));
                        ++otherIndex;
                        continue;
                    }
                    result.add((ICommit)objectCommits.get(objectIndex++));
                    continue;
                }
                if (otherCommits.size() <= otherIndex) continue;
                result.add((ICommit)otherCommits.get(otherIndex++));
            }
            return result;
        }).orElseGet(List::of);
    }
}

