/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.FullCommitID;
import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.app.services.ICommitEditingContextService;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshotNode;
import fr.obeo.perseus.server.services.api.model.BasicModelID;
import fr.obeo.perseus.server.services.api.model.IModelID;
import fr.obeo.perseus.server.services.api.model.versioning.IModelHistorySearchService;
import fr.obeo.perseus.server.services.api.model.versioning.IModelSnapshotSearchService;
import fr.obeo.perseus.server.versioning.ICommit;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IEditingContextProcessor;
import org.eclipse.sirius.components.core.api.IEditingContextRepresentationDescriptionProvider;
import org.eclipse.sirius.components.core.api.IEditingContextSearchService;
import org.eclipse.sirius.web.application.project.services.api.IProjectEditingContextService;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service
public class PerseusEditingContextSearchService
implements IEditingContextSearchService {
    private final IProjectEditingContextService projectEditingContextService;
    private final ICommitEditingContextService commitEditingContextService;
    private final IModelSnapshotSearchService modelSnapshotSearchService;
    private final IModelHistorySearchService modelHistorySearchService;
    private final List<IEditingContextRepresentationDescriptionProvider> representationDescriptionProviders;
    private final List<IEditingContextProcessor> editingContextProcessors;

    public PerseusEditingContextSearchService(IProjectEditingContextService projectEditingContextService, ICommitEditingContextService commitEditingContextService, IModelSnapshotSearchService modelSnapshotSearchService, IModelHistorySearchService modelHistorySearchService, List<IEditingContextRepresentationDescriptionProvider> representationDescriptionProviders, List<IEditingContextProcessor> editingContextProcessors) {
        this.projectEditingContextService = Objects.requireNonNull(projectEditingContextService);
        this.commitEditingContextService = Objects.requireNonNull(commitEditingContextService);
        this.modelSnapshotSearchService = Objects.requireNonNull(modelSnapshotSearchService);
        this.modelHistorySearchService = Objects.requireNonNull(modelHistorySearchService);
        this.representationDescriptionProviders = Objects.requireNonNull(representationDescriptionProviders);
        this.editingContextProcessors = Objects.requireNonNull(editingContextProcessors);
    }

    @Transactional(readOnly=true)
    public boolean existsById(String editingContextId) {
        boolean result = this.projectEditingContextService.getProjectId(editingContextId).isPresent();
        result = result || this.commitEditingContextService.getCommit(editingContextId).isPresent();
        return result;
    }

    @Transactional(readOnly=true)
    public Optional<IEditingContext> findById(String editingContextId) {
        return this.projectEditingContextService.getProjectId(editingContextId).map(projectId -> this.toProjectEditingContext(editingContextId, projectId)).or(() -> this.commitEditingContextService.getCommit(editingContextId).flatMap(commit -> CommitEditingContext.parseCommitId((String)editingContextId).map(FullCommitID::projectId).flatMap(projectId -> this.toCommitEditingContext(projectId, commit))));
    }

    private IEditingContext toProjectEditingContext(String editingContextId, String projectId) {
        ProjectEditingContext editingContext = new ProjectEditingContext(editingContextId, projectId, new HashMap());
        this.editingContextProcessors.forEach(processor -> processor.preProcess((IEditingContext)editingContext));
        this.representationDescriptionProviders.forEach(representationDescriptionProvider -> {
            List representationDescriptions = representationDescriptionProvider.getRepresentationDescriptions((IEditingContext)editingContext);
            representationDescriptions.forEach(representationDescription -> editingContext.getRepresentationDescriptions().put(representationDescription.getId(), representationDescription));
        });
        this.editingContextProcessors.forEach(processor -> processor.postProcess((IEditingContext)editingContext));
        return editingContext;
    }

    private Optional<IEditingContext> toCommitEditingContext(String projectId, ICommit commit) {
        return this.modelHistorySearchService.findModelHistoryByBranchId(commit.getId().getBranchId()).flatMap(modelHistory -> {
            BasicModelID modelId = new BasicModelID(projectId, modelHistory.getModelId());
            return this.modelSnapshotSearchService.findModelSnapshot((IModelID)modelId, commit).map(modelSnapshot -> {
                ModelSnapshotNode ims = new ModelSnapshotNode((IModelID)modelId, commit.getId(), modelSnapshot);
                CommitEditingContext editingContext = new CommitEditingContext(projectId, commit, ims, new HashMap());
                this.editingContextProcessors.forEach(processor -> processor.preProcess((IEditingContext)editingContext));
                this.representationDescriptionProviders.forEach(representationDescriptionProvider -> {
                    List representationDescriptions = representationDescriptionProvider.getRepresentationDescriptions((IEditingContext)editingContext);
                    representationDescriptions.forEach(representationDescription -> editingContext.getRepresentationDescriptions().put(representationDescription.getId(), representationDescription));
                });
                this.editingContextProcessors.forEach(processor -> processor.postProcess((IEditingContext)editingContext));
                return editingContext;
            });
        });
    }
}

