/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.services.IEditingContextAwareRepresentationMetadataProvider;
import java.util.List;
import java.util.Objects;
import org.eclipse.sirius.components.collaborative.api.ChangeDescription;
import org.eclipse.sirius.components.collaborative.api.IEditingContextEventHandler;
import org.eclipse.sirius.components.collaborative.dto.GetRepresentationDescriptionInput;
import org.eclipse.sirius.components.collaborative.dto.GetRepresentationDescriptionPayload;
import org.eclipse.sirius.components.core.RepresentationMetadata;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.core.api.IRepresentationDescriptionSearchService;
import org.eclipse.sirius.components.representations.IRepresentationDescription;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Sinks;

@Service
public class PerseusGetRepresentationDescriptionEventHandler
implements IEditingContextEventHandler {
    private final List<IEditingContextAwareRepresentationMetadataProvider> representationMetadataProviders;
    private final IRepresentationDescriptionSearchService representationDescriptionSearchService;

    public PerseusGetRepresentationDescriptionEventHandler(List<IEditingContextAwareRepresentationMetadataProvider> representationMetadataProviders, IRepresentationDescriptionSearchService representationDescriptionSearchService) {
        this.representationMetadataProviders = representationMetadataProviders;
        this.representationDescriptionSearchService = Objects.requireNonNull(representationDescriptionSearchService);
    }

    public boolean canHandle(IEditingContext editingContext, IInput input) {
        return input instanceof GetRepresentationDescriptionInput;
    }

    public void handle(Sinks.One<IPayload> payloadSink, Sinks.Many<ChangeDescription> changeDescriptionSink, IEditingContext editingContext, IInput input) {
        if (input instanceof GetRepresentationDescriptionInput) {
            GetRepresentationDescriptionInput getRepresentationDescriptionInput = (GetRepresentationDescriptionInput)input;
            IRepresentationDescription representationDescription = this.representationMetadataProviders.stream().flatMap(provider -> provider.getMetadata(editingContext, getRepresentationDescriptionInput.representationId()).stream()).findFirst().map(RepresentationMetadata::descriptionId).flatMap(representationDescriptionId -> this.representationDescriptionSearchService.findById(editingContext, representationDescriptionId)).orElse(null);
            GetRepresentationDescriptionPayload payload = new GetRepresentationDescriptionPayload(input.id(), representationDescription);
            payloadSink.tryEmitValue((Object)payload);
            changeDescriptionSink.tryEmitNext((Object)new ChangeDescription("NOTHING", editingContext.getId(), input));
        }
    }
}

