/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.repositories.IModelRepository;
import fr.obeo.perseus.server.services.api.IModelService;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IObjectSearchServiceDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PerseusObjectSearchServiceDelegate
implements IObjectSearchServiceDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(PerseusObjectSearchServiceDelegate.class);
    private final IModelService modelService;
    private final IModelRepository modelRepository;

    public PerseusObjectSearchServiceDelegate(IModelService modelService, IModelRepository modelRepository) {
        this.modelService = Objects.requireNonNull(modelService);
        this.modelRepository = Objects.requireNonNull(modelRepository);
    }

    /*
     * Unable to fully structure code
     */
    public boolean canHandle(IEditingContext editingContext, String objectId) {
        if (!(editingContext instanceof ProjectEditingContext)) ** GOTO lbl-1000
        pec = (ProjectEditingContext)editingContext;
        if (PerseusRepresentationUtils.isModelObjectRepId((String)objectId) || PerseusRepresentationUtils.isModelRepId((String)objectId) || pec.getProjectId().equals(objectId)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = result = false;
        }
        if (PerseusObjectSearchServiceDelegate.LOG.isDebugEnabled()) {
            PerseusObjectSearchServiceDelegate.LOG.debug(String.format("%s - can handle object '%s' in editing context %s: %b", new Object[]{this.getClass().getSimpleName(), objectId, editingContext, result}));
        }
        return result;
    }

    public Optional<Object> getObject(IEditingContext editingContext, String objectId) {
        ProjectEditingContext pec;
        Optional<Object> result = Optional.empty();
        if (editingContext instanceof ProjectEditingContext && (pec = (ProjectEditingContext)editingContext).getProjectId().equals(objectId)) {
            result = Optional.of(objectId);
        } else if (PerseusRepresentationUtils.isModelObjectRepId((String)objectId)) {
            long modelID = PerseusRepresentationUtils.getModelId((String)objectId);
            String modelObjectID = PerseusRepresentationUtils.getModelObjectId((String)objectId);
            result = this.modelService.getModelObject(modelID, modelObjectID).map(Object.class::cast);
        } else if (PerseusRepresentationUtils.isModelRepId((String)objectId)) {
            long modelID = PerseusRepresentationUtils.getModelId((String)objectId);
            result = this.modelRepository.findById((Object)modelID).map(Object.class::cast);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%s - getObject '%s' in editing context %s returns: %s", this.getClass().getSimpleName(), objectId, editingContext, result));
        }
        return result;
    }
}

