/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import java.util.Map;
import java.util.Optional;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IRepresentationDescriptionSearchService;
import org.eclipse.sirius.components.representations.IRepresentationDescription;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class PerseusRepresentationDescriptionSearchService
implements IRepresentationDescriptionSearchService {
    public Map<String, IRepresentationDescription> findAll(IEditingContext editingContext) {
        if (editingContext instanceof ProjectEditingContext) {
            ProjectEditingContext projectEditingContext = (ProjectEditingContext)editingContext;
            return projectEditingContext.getRepresentationDescriptions();
        }
        if (editingContext instanceof CommitEditingContext) {
            CommitEditingContext commitEditingContext = (CommitEditingContext)editingContext;
            return commitEditingContext.getRepresentationDescriptions();
        }
        return Map.of();
    }

    public Optional<IRepresentationDescription> findById(IEditingContext editingContext, String representationDescriptionId) {
        if (editingContext instanceof ProjectEditingContext) {
            ProjectEditingContext projectEditingContext = (ProjectEditingContext)editingContext;
            return Optional.ofNullable((IRepresentationDescription)projectEditingContext.getRepresentationDescriptions().get(representationDescriptionId));
        }
        if (editingContext instanceof CommitEditingContext) {
            CommitEditingContext commitEditingContext = (CommitEditingContext)editingContext;
            return Optional.ofNullable((IRepresentationDescription)commitEditingContext.getRepresentationDescriptions().get(representationDescriptionId));
        }
        return Optional.empty();
    }
}

