/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.content;

import fr.obeo.perseus.server.services.api.IModelService;
import fr.obeo.perseus.server.services.api.ITreeNode;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import fr.obeo.perseus.server.services.api.dto.model.RepresentationTypeNode;
import fr.obeo.perseus.server.usersettings.services.api.IMetaclassFilter;
import fr.obeo.perseus.server.util.MetaclassPredicates;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.sirius.components.core.api.IContentServiceDelegate;
import org.springframework.stereotype.Component;

@Component
public class ModelObjectNodeContentServiceDelegate
implements IContentServiceDelegate {
    private final IModelService modelService;
    private final Supplier<IMetaclassFilter> metaclassFilterSupplier;

    public ModelObjectNodeContentServiceDelegate(IModelService modelService, Supplier<IMetaclassFilter> metaclassFilterSupplier) {
        this.modelService = Objects.requireNonNull(modelService);
        this.metaclassFilterSupplier = Objects.requireNonNull(metaclassFilterSupplier);
    }

    public boolean canHandle(Object object) {
        return object instanceof ModelObjectNode;
    }

    public List<Object> getContents(Object object) {
        ModelObjectNode mon = (ModelObjectNode)object;
        ArrayList<Object> result = new ArrayList();
        IMetaclassFilter metaclassFilter = (IMetaclassFilter)this.metaclassFilterSupplier.get();
        Predicate monFilter = MetaclassPredicates.treeNodePredicate((IMetaclassFilter)metaclassFilter);
        result = this.modelService.getChildren(mon.getModelId(), mon.getId()).filter(tn -> monFilter.test(tn) && (!(tn instanceof RepresentationTypeNode) || ((RepresentationTypeNode)tn).getRepresentations().stream().anyMatch(rep -> {
            ITreeNode treeNode;
            return rep instanceof ITreeNode && monFilter.test(treeNode = (ITreeNode)rep);
        }))).collect(Collectors.toList());
        return result;
    }
}

