/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.label;

import fr.obeo.perseus.server.ModelObjectID;
import fr.obeo.perseus.server.meta.services.api.IMetaclassRegistry;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.core.api.ILabelServiceDelegate;
import org.eclipse.sirius.components.core.api.labels.StyledString;
import org.springframework.stereotype.Component;

@Component
public class ModelObjectNodeLabelServiceDelegate
implements ILabelServiceDelegate {
    private final IIconService iconService;
    private final IMetaclassRegistry metaclassRegistry;
    private final IModelObjectRepository modelObjectRepository;

    public ModelObjectNodeLabelServiceDelegate(IIconService iconService, IMetaclassRegistry metaclassRegistry, IModelObjectRepository modelObjectRepository) {
        this.iconService = Objects.requireNonNull(iconService);
        this.metaclassRegistry = Objects.requireNonNull(metaclassRegistry);
        this.modelObjectRepository = Objects.requireNonNull(modelObjectRepository);
    }

    public boolean canHandle(Object object) {
        return object instanceof ModelObjectNode;
    }

    public StyledString getStyledLabel(Object object) {
        return StyledString.of((String)((ModelObjectNode)object).getLabel());
    }

    public List<String> getImagePaths(Object object) {
        ModelObjectNode mon = (ModelObjectNode)object;
        String imageURL = null;
        long metaclassId = mon.getMetaclassId();
        if (this.metaclassRegistry.getMetaclassByUid(metaclassId).filter(arg_0 -> ((IMetaclassRegistry)this.metaclassRegistry).isRepresentationDescriptor(arg_0)).isPresent()) {
            metaclassId = this.modelObjectRepository.loadChildrenMetaclassIds(new ModelObjectID(mon.getModelId(), mon.getId())).stream().findFirst().orElse(metaclassId);
        }
        imageURL = this.iconService.getIconPath(mon.getIconHash(), metaclassId);
        return List.of(Optional.ofNullable(imageURL).orElse("/icons/svg/Resource.svg"));
    }
}

