/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.label;

import fr.obeo.perseus.server.dto.meta.MClassifierDTO;
import fr.obeo.perseus.server.dto.meta.MetaclassDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.meta.services.api.IMetamodelRegistry;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.dto.versioning.DerivedModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.IntrinsicModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.core.api.ILabelServiceDelegate;
import org.eclipse.sirius.components.core.api.labels.StyledString;
import org.springframework.stereotype.Component;

@Component
public class ModelObjectSnapshotNodeLabelServiceDelegate
implements ILabelServiceDelegate {
    private final IIconService iconService;
    private final IMetamodelRegistry metamodelRegistry;
    private final ICommitSearchService commitSearchService;
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;

    public ModelObjectSnapshotNodeLabelServiceDelegate(IIconService iconService, IMetamodelRegistry metamodelRegistry, ICommitSearchService commitSearchService, IModelObjectSnapshotSearchService modelObjectSnapshotSearchService) {
        this.iconService = Objects.requireNonNull(iconService);
        this.metamodelRegistry = Objects.requireNonNull(metamodelRegistry);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
    }

    public boolean canHandle(Object object) {
        return object instanceof ModelObjectSnapshotNode;
    }

    public StyledString getStyledLabel(Object object) {
        ModelObjectSnapshotNode moSnapshot = (ModelObjectSnapshotNode)object;
        if (moSnapshot.snapshot().getIntrinsic().getMetaclass().isAnalysis()) {
            return StyledString.of((String)"Representations per Viewpoint");
        }
        return Optional.ofNullable(moSnapshot.snapshot().getDerived()).map(DerivedModelObjectData::getTitle).or(() -> Optional.ofNullable(moSnapshot.snapshot().getIntrinsic()).map(IntrinsicModelObjectData::getName)).map(StyledString::of).orElseGet(() -> StyledString.of((String)"<Unnamed>"));
    }

    public List<String> getImagePaths(Object object) {
        ModelObjectSnapshotNode imos = (ModelObjectSnapshotNode)object;
        String imageURL = null;
        MetaclassQName metaclassQName = imos.snapshot().getIntrinsic().getMetaclass();
        ModelObjectSnapshotNode target = metaclassQName.isRepresentationDescriptor() ? Optional.ofNullable(imos.snapshot().getIntrinsic().getStructuralFeatureSettings().get("representation")).filter(String.class::isInstance).map(String.class::cast).flatMap(reprId -> this.commitSearchService.findCommit(imos.model().id().getProjectId(), imos.model().commitId()).flatMap(commit -> this.modelObjectSnapshotSearchService.findModelObjectInCommit(imos.model().id().forObject(reprId), commit)).map(mos -> new ModelObjectSnapshotNode(imos.model(), reprId, mos))).orElse(imos) : imos;
        MetaclassQName targetMetaclassQName = target.snapshot().getIntrinsic().getMetaclass();
        MetaclassDTO metaclass = target.model().snapshot().intrinsic().getMetamodels().values().stream().filter(info -> info.getNsURI().equals(targetMetaclassQName.nsUri())).findFirst().flatMap(mmInfo -> this.metamodelRegistry.getMetamodelByHash(mmInfo.getHash())).map(mmDTO -> (MClassifierDTO)mmDTO.getClassifiers().get(targetMetaclassQName.name())).filter(MetaclassDTO.class::isInstance).map(MetaclassDTO.class::cast).orElseGet(MetaclassDTO::unknown);
        long metaclassId = metaclass.getUid();
        imageURL = this.iconService.getIconPath(Optional.ofNullable(target.snapshot().getDerived()).map(DerivedModelObjectData::getIconHash).orElseGet(() -> target.snapshot().getIntrinsic().getIconHash()), metaclassId);
        return List.of(Optional.ofNullable(imageURL).orElse("/icons/svg/Resource.svg"));
    }
}

