/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.sb;

import fr.obeo.perseus.server.app.services.sb.SemanticBrowserPanel;
import fr.obeo.perseus.server.common.LabelUtil;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import fr.obeo.perseus.server.services.api.dto.versioning.DerivedModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.semanticbrowser.SemanticBrowserTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.core.api.ILabelService;
import org.eclipse.sirius.components.emf.forms.api.IPropertiesValidationProvider;
import org.eclipse.sirius.components.forms.TreeNode;
import org.eclipse.sirius.components.forms.description.TreeDescription;
import org.eclipse.sirius.components.representations.Success;
import org.eclipse.sirius.components.representations.VariableManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.lang.NonNull;

public class SemanticBrowserTreeProvider {
    private static final String WIDGET_ID = "SemanticBrowser";
    private static final String FOLDER_ICON_URL = "/static/images/folder_black_24dp.svg";
    @NonNull
    private final IIdentityService identityService;
    @NonNull
    private final ILabelService labelService;
    @NonNull
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final Function<VariableManager, String> semanticTargetIdProvider;
    private final IPropertiesValidationProvider propertiesValidationProvider = new IPropertiesValidationProvider.NoOp();

    public SemanticBrowserTreeProvider(IIdentityService identityService, ILabelService labelService, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor) {
        this.identityService = Objects.requireNonNull(identityService);
        this.labelService = Objects.requireNonNull(labelService);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.semanticTargetIdProvider = variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElse(null);
    }

    public TreeDescription getTreeDescription() {
        return TreeDescription.newTreeDescription((String)WIDGET_ID).idProvider(arg_0 -> this.getWidgetId(arg_0)).targetObjectIdProvider(this.semanticTargetIdProvider).labelProvider(arg_0 -> this.getLabel(arg_0)).iconURLProvider(arg_0 -> this.getIconURL(arg_0)).childrenProvider(arg_0 -> this.getCurrentChildren(arg_0)).nodeIdProvider(arg_0 -> this.getNodeId(arg_0)).nodeLabelProvider(arg_0 -> this.getNodeLabel(arg_0)).nodeKindProvider(arg_0 -> this.getNodeKind(arg_0)).nodeIconURLProvider(arg_0 -> this.getNodeIconURL(arg_0)).nodeEndIconsURLProvider(variableManager -> List.of()).nodeSelectableProvider(arg_0 -> this.isNodeSelectable(arg_0)).isCheckableProvider(variableManager -> false).checkedValueProvider(variableManager -> false).newCheckedValueHandler((variableManager, newValue) -> new Success()).expandedNodeIdsProvider(arg_0 -> this.collectAllNodeIds(arg_0)).diagnosticsProvider(this.propertiesValidationProvider.getDiagnosticsProvider()).kindProvider(this.propertiesValidationProvider.getKindProvider()).messageProvider(this.propertiesValidationProvider.getMessageProvider()).build();
    }

    private String getWidgetId(VariableManager variableManager) {
        return this.getSBPanel(variableManager).kind().name();
    }

    private String getLabel(VariableManager variableManager) {
        return this.getSBPanel(variableManager).kind().getLabel(this.modelAppMessageSourceAccessor);
    }

    private List<String> getIconURL(VariableManager variableManager) {
        return this.getSBPanel(variableManager).kind().getIconURL();
    }

    private SemanticBrowserPanel getSBPanel(VariableManager variableManager) {
        return (SemanticBrowserPanel)variableManager.get("sbPanel", SemanticBrowserPanel.class).get();
    }

    private List<?> getCurrentChildren(VariableManager variableManager) {
        return variableManager.get("self", Object.class).map(self -> this.getCurrentChildren(self, this.getSBPanel(variableManager))).orElseGet(List::of);
    }

    private List<?> getCurrentChildren(Object self, SemanticBrowserPanel panel) {
        List result;
        if (self instanceof ModelObjectNode || self instanceof ModelObjectSnapshotNode) {
            result = panel.getRoots();
        } else if (self instanceof SemanticBrowserTreeNode) {
            SemanticBrowserTreeNode sbtn = (SemanticBrowserTreeNode)self;
            result = Optional.ofNullable(sbtn.getChildren()).orElseGet(List::of);
        } else {
            result = List.of();
        }
        return result;
    }

    private String getNodeId(VariableManager variableManager) {
        Object result = null;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof ModelObjectNode) {
            ModelObjectNode node = self;
            result = "mon/" + node.getId();
        } else if (self instanceof ModelObjectSnapshotNode) {
            ModelObjectSnapshotNode imos = self;
            result = "imos/" + imos.objectId();
        } else if (self instanceof SemanticBrowserTreeNode) {
            SemanticBrowserTreeNode sbtn = self;
            result = sbtn.getTargetUID() != null ? sbtn.getTargetUID() + "%" + sbtn.getId() : sbtn.getKind() + "/" + sbtn.getId();
        } else if (self != null) {
            result = this.identityService.getId(self);
        }
        return result;
    }

    private String getNodeLabel(VariableManager variableManager) {
        String result = null;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof ModelObjectNode) {
            ModelObjectNode node = self;
            result = node.getLabel();
        } else if (self instanceof ModelObjectSnapshotNode) {
            ModelObjectSnapshotNode imos = self;
            result = Optional.ofNullable(imos.snapshot().getDerived()).map(DerivedModelObjectData::getTitle).orElse(null);
        } else if (self instanceof SemanticBrowserTreeNode) {
            SemanticBrowserTreeNode sbtn = self;
            result = sbtn.getLabel();
        } else if (self != null) {
            result = LabelUtil.getTruncatedLabel((String)this.labelService.getStyledLabel(self).toString());
        }
        if (result == null) {
            result = "<Unnamed>";
        }
        return result;
    }

    private List<String> getNodeIconURL(VariableManager variableManager) {
        List result = null;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof ModelObjectNode || self instanceof ModelObjectSnapshotNode) {
            result = List.of(FOLDER_ICON_URL);
        } else if (self instanceof SemanticBrowserTreeNode) {
            SemanticBrowserTreeNode sbtn = self;
            result = List.of(sbtn.getIconURL());
        } else if (self != null) {
            result = this.labelService.getImagePaths(self);
        }
        return result;
    }

    private String getNodeKind(VariableManager variableManager) {
        String result = null;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof ModelObjectNode || self instanceof ModelObjectSnapshotNode) {
            result = "perseus://ModelObject";
        } else if (self instanceof SemanticBrowserTreeNode) {
            SemanticBrowserTreeNode sbtn = self;
            result = sbtn.getKind();
            if ("C".equals(result)) {
                result = "obeoStudio://category";
            }
        } else if (self != null) {
            result = this.identityService.getKind(self);
        }
        return result;
    }

    private boolean isNodeSelectable(VariableManager variableManager) {
        boolean result = false;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof SemanticBrowserTreeNode) {
            SemanticBrowserTreeNode sbtn = self;
            result = "O".equals(sbtn.getKind());
        }
        return result;
    }

    private List<String> collectAllNodeIds(VariableManager variableManager) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : variableManager.get("nodes", List.class).orElse(List.of())) {
            if (!(element instanceof TreeNode)) continue;
            TreeNode node = (TreeNode)element;
            result.add(node.getId());
        }
        return result;
    }
}

