/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.versioning;

import fr.obeo.perseus.server.app.services.versioning.NewCommitInput;
import fr.obeo.perseus.server.oslc.api.IModelOslcLinksInput;
import fr.obeo.perseus.server.services.api.model.ModelSaveInput;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.api.CommitInput;
import fr.obeo.perseus.server.versioning.events.CommitCreated;
import java.util.Objects;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.events.ICause;
import org.eclipse.sirius.components.graphql.api.IEditingContextDispatcher;
import org.eclipse.sirius.web.application.project.services.api.IProjectEditingContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class NotifyEditingContextOnCommitCreated {
    private static final Logger LOG = LoggerFactory.getLogger(NotifyEditingContextOnCommitCreated.class);
    private final IEditingContextDispatcher editingContextDispatcher;
    private final IProjectEditingContextService projectEditingContextService;

    public NotifyEditingContextOnCommitCreated(IEditingContextDispatcher editingContextDispatcher, IProjectEditingContextService projectEditingContextService) {
        this.editingContextDispatcher = Objects.requireNonNull(editingContextDispatcher);
        this.projectEditingContextService = Objects.requireNonNull(projectEditingContextService);
    }

    @TransactionalEventListener
    public void onNewCommit(CommitCreated event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Received CommitCreated %s", event));
        }
        CommitID commitID = event.getCommit().getCommitId();
        CommitInput input = (CommitInput)event.causedBy();
        ICause cause = input.causedBy();
        String projectId = null;
        if (cause instanceof ModelSaveInput) {
            ModelSaveInput modelSaveInput = (ModelSaveInput)cause;
            projectId = modelSaveInput.modelUpdate().getProjectId();
            this.projectEditingContextService.getEditingContextId(projectId).ifPresent(editingContextId -> this.editingContextDispatcher.dispatchMutation(editingContextId, (IInput)new NewCommitInput(input, commitID)));
        } else if (cause instanceof IModelOslcLinksInput) {
            IModelOslcLinksInput oslcInput = (IModelOslcLinksInput)cause;
            this.editingContextDispatcher.dispatchMutation(oslcInput.editingContextId(), (IInput)new NewCommitInput(input, commitID));
        }
    }
}

