#!/bin/bash
echo Installing Publication for Capella in Capella

export CALLER_PATH="$(pwd)"
cd "$(dirname "$0")"
export SCRIPT_PATH="$(pwd)"
cd -

# Features relevant for installing in T4C client
export P4C_FEATURES="fr.obeo.dsl.traceability.capella.feature.feature.group,fr.obeo.perseus.client.capella.feature.feature.group,fr.obeo.dsl.traceability.cdo.feature.feature.group,fr.obeo.perseus.client.ui.feature.feature.group,fr.obeo.sirius.texttransfer.drop.feature.feature.group,fr.obeo.perseus.client.feature.feature.group,fr.obeo.dsl.traceability.feature.feature.group"

# Features relevant for installing in plain Capella
# export P4C_FEATURES="fr.obeo.dsl.traceability.capella.feature.feature.group,fr.obeo.perseus.client.capella.feature.feature.group,fr.obeo.perseus.client.ui.feature.feature.group,fr.obeo.sirius.texttransfer.drop.feature.feature.group,fr.obeo.perseus.client.feature.feature.group,fr.obeo.dsl.traceability.feature.feature.group"

cd "$SCRIPT_PATH/../capella"

chmod +x capella

WORKSPACE_NAME=installationWorkspace
WORKSPACE_EXISTS_BEFORE=0
if [ -d "$WORKSPACE_NAME" ]; then
  WORKSPACE_EXISTS_BEFORE=1
fi

echo +-------------------------------------------------------+
echo + Uninstall previous Publication for Capella if present +
echo +-------------------------------------------------------+
./capella \
-nosplash -console -consoleLog \
-data "$WORKSPACE_NAME" \
-application org.eclipse.equinox.p2.director \
-tag "Uninstall previous PublicationForCapella" \
-uninstallIU "$P4C_FEATURES" \

UNINSTALL_CODE=$?
if [ $UNINSTALL_CODE -eq 0 ]; then
    echo -------------------------------------------------------
    echo Uninstall successful.
    echo -------------------------------------------------------
else
    echo -------------------------------------------------------------------------------------
    echo Uninstall returned code $UNINSTALL_CODE, this is expected in many cases so proceeding anyway.
    echo -------------------------------------------------------------------------------------
fi

echo +-------------------------------------+
echo + Install new Publication for Capella +
echo +-------------------------------------+
./capella \
-nosplash -console -consoleLog \
-data "$WORKSPACE_NAME" \
-application org.eclipse.equinox.p2.director \
-tag "Install PublicationForCapella 2025.10.0" \
-installIU "$P4C_FEATURES" \
-repository "jar:file://$SCRIPT_PATH/../updateSite/fr.obeo.perseus.client.updatesite-2025.10.0.zip!/"

INSTALL_CODE=$?
if [ $INSTALL_CODE -eq 0 ]; then
    echo -------------------
    echo Install successful.
    echo -------------------
else
    echo ----------------------------------
    echo Install failed with exit code $INSTALL_CODE
    echo ----------------------------------
fi

if [ $WORKSPACE_EXISTS_BEFORE -eq 0 ] && [ -d "$WORKSPACE_NAME" ]; then
  rm -rf "$WORKSPACE_NAME"
fi
cd "$CALLER_PATH"
