import { GQLAccount } from '../../Core.types';
import { GQLOAuthRequestTokenDetails } from './OAuthRequestTokenForm.types';
export interface OAuthRequestTokenStateSchema {
    states: {
        oauthRequestToken: {
            states: {
                verifyingToken: {};
                invalid: {};
                valid: {};
            };
        };
    };
}
export type SchemaValue = {
    oauthRequestToken: 'verifyingToken' | 'invalid' | 'valid';
};
export interface OAuthRequestTokenContext {
    currentAccount: GQLAccount | null;
    details: GQLOAuthRequestTokenDetails | null;
}
export type HandleFetchedTokenDetailsEvent = {
    type: 'HANDLE_FETCHED_TOKEN_DETAILS';
    currentAccount: GQLAccount;
    requestTokenDetails: GQLOAuthRequestTokenDetails;
};
export type OAuthRequestTokenEvent = HandleFetchedTokenDetailsEvent;
export declare const oauthRequestTokenMachine: import("xstate").StateMachine<OAuthRequestTokenContext, OAuthRequestTokenStateSchema, HandleFetchedTokenDetailsEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, HandleFetchedTokenDetailsEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=OAuthRequestTokenMachine.d.ts.map