/***********************************************************************************************
 * Copyright (c) 2023 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLBasicAuthProblem, GQLOAuthFriend, GQLOAuthProblem } from '../oauth/OAuth.types';
export interface GQLOslcAssociationDescriptor {
    uid: string;
    projectId: string;
    oauthFriend: GQLOAuthFriend;
    serviceProviderURI: string;
    serviceProviderTitle: string;
    options: GQLOslcAssociationOptions;
}
export interface GQLOslcAssociationOptions {
    selectionDialogs: boolean;
    creationDialogs: boolean;
    multipleCreation: boolean;
}
export interface GQLOslcAssociation {
    uid: string;
    projectId: string;
    oauthFriend: GQLOAuthFriend;
    serviceProviderTitle: string;
    serviceProvider: GQLOslcServiceProvider;
    options: GQLOslcAssociationOptions;
}
export interface GQLOslcServiceProvider {
    title: string;
    about: string;
    services: GQLOslcService[];
}
export interface GQLOslcService {
    selectionDialogs: GQLOslcDialog[];
    creationDialogs: GQLOslcDialog[];
}
export interface GQLOslcDialog {
    title: string;
    label: string;
    hintHeight: string;
    hintWidth: string;
    dialog: string;
    resourceTypes: string[];
}
export interface GQLOslcPreview {
    typeURI: string;
    document: string;
    hintHeight: string;
    hintWidth: string;
}
export interface GQLOslcLinking {
    linkType: GQLOslcLinkType;
    types: GQLOslcType[];
}
export interface GQLOslcLinkType {
    uri: string;
    label: string;
    reverseURI: string;
}
export interface GQLOslcType {
    uri: string;
    label: string;
}
export interface GQLInvalidLinkDescriptor {
    id: string;
    status: string;
    qnameNsUri: string;
    qnameLocalPart: string;
    sourceId: string;
    broken: boolean;
    missing: boolean;
    sourceLabel: string;
    sourceTypeName: string;
    sourceIconURL: string;
    targetTitle: string;
    targetURL: string;
}
export interface GQLOslcCompactResourceFetchResult {
    __typename: string;
}
export interface GQLOslcCompactResourceFetchSuccess extends GQLOslcCompactResourceFetchResult {
    artifactUrl: string;
    title: string;
    iconUrl: string;
}
export interface GQLOslcCompactResourceFetchError extends GQLOslcCompactResourceFetchResult {
    artifactUrl: string;
    error: GQLOslcCompactResourceError;
}
export declare const isOslcCompactResourceFetchSuccess: (fetchResult: {
    __typename: string;
}) => fetchResult is GQLOslcCompactResourceFetchSuccess;
export declare const isOslcCompactResourceFetchError: (fetchResult: {
    __typename: string;
}) => fetchResult is GQLOslcCompactResourceFetchError;
export interface GQLOslcCompactResourceError {
    __typename: string;
}
export interface ErrorPayload extends GQLOslcCompactResourceError {
    message: string;
}
export interface GQLOAuthProblemPayload extends GQLOslcCompactResourceError, GQLOAuthProblem {
    __typename: string;
}
export interface GQLBasicAuthProblemPayload extends GQLOslcCompactResourceError, GQLBasicAuthProblem {
    __typename: string;
}
export interface GQLUpdateModelObjectOslcLinksPayload {
    __typename: string;
}
export interface GQLUpdateModelObjectOslcLinksSuccessPayload extends GQLUpdateModelObjectOslcLinksPayload {
    message: string;
}
//# sourceMappingURL=Oslc.types.d.ts.map