/***********************************************************************************************
 * Copyright (c) 2025 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLMessage } from '@eclipse-sirius/sirius-components-core';
import { GQLFriendDescriptor, GQLOAuthFriend } from '../../core/oauth/OAuth.types';
export interface UseAvailableJamaTypesValue {
    availableJamaTypes: GQLJamaType[] | null;
    authenticationRequired: GQLApiKeyUserAuthorizationPayload | null;
    loading: boolean;
    refetch: () => void;
}
export interface GQLAvailableJamaTypesQueryVariables {
    key: string;
}
export interface GQLAvailableJamaTypesQueryData {
    viewer: GQLViewer;
}
export interface GQLViewer {
    oauthFriend: GQLJamaFriend;
}
export interface GQLJamaFriend extends GQLOAuthFriend {
    availableJamaTypes: GQLAvailableJamaTypesPayload;
}
export interface GQLAvailableJamaTypesPayload {
    __typename: string;
}
export interface GQLAvailableJamaTypesSuccessPayload extends GQLAvailableJamaTypesPayload {
    types: GQLJamaType[];
}
export interface GQLErrorPayload extends GQLAvailableJamaTypesPayload {
    message: string;
    messages: GQLMessage[];
}
export interface GQLApiKeyUserAuthorizationPayload extends GQLAvailableJamaTypesPayload {
    hostName: string;
    friendDescriptor: GQLFriendDescriptor;
}
export interface GQLJamaType {
    id: number;
    typeKey: string;
    display: string;
    image: string;
}
//# sourceMappingURL=useAvailableJamaTypes.types.d.ts.map