/***********************************************************************************************
 * Copyright (c) 2025 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLMessage } from '@eclipse-sirius/sirius-components-core';
export interface UseRegisterFriendApiKeyValue {
    registerFriendApiKey: (friendKey: string, key: string, secret: string) => void;
    loading: boolean;
    apiKeyRegistered: GQLRegisterFriendApiKeySuccessPayload | null;
}
export interface GQLRegisterFriendApiKeyMutationData {
    registerFriendApiKey: GQLRegisterFriendApiKeyPayload;
}
export interface GQLRegisterFriendApiKeyPayload {
    __typename: string;
}
export interface GQLRegisterFriendApiKeySuccessPayload extends GQLRegisterFriendApiKeyPayload {
}
export interface GQLErrorPayload extends GQLRegisterFriendApiKeyPayload {
    message: string;
    messages: GQLMessage[];
}
export interface GQLRegisterFriendApiKeyMutationVariables {
    input: GQLRegisterFriendApiKeyInput;
}
export interface GQLRegisterFriendApiKeyInput {
    id: string;
    friendKey: string;
    key: string;
    secret: string;
}
//# sourceMappingURL=useRegisterFriendApiKey.types.d.ts.map