import { GQLRegisterFriendCredentialsPayload } from './BasicAuthFriendModal.types';
export interface RegisterFriendCredentialsSchema {
    states: {
        registerFriendCredentials: {
            states: {
                pristine: {};
                valid: {};
                invalid: {};
                processing: {};
                success: {};
            };
        };
    };
}
export type SchemaValue = {
    registerFriendCredentials: 'pristine' | 'valid' | 'invalid' | 'processing' | 'success';
};
export interface RegisterFriendCredentialsContext {
    login: string | null;
    password: string | null;
}
export type ChangeLoginEvent = {
    type: 'CHANGE_LOGIN';
    login: string;
};
export type ChangePasswordEvent = {
    type: 'CHANGE_PASSWORD';
    password: string;
};
export type RegisterEvent = {
    type: 'REGISTER';
};
export type HandleRegisteredEvent = {
    type: 'HANDLE_REGISTERED';
    data: GQLRegisterFriendCredentialsPayload;
};
export type RegisterFriendCredentialsEvent = ChangeLoginEvent | ChangePasswordEvent | RegisterEvent | HandleRegisteredEvent;
export declare const registerFriendCredentialsMachine: import("xstate").StateMachine<RegisterFriendCredentialsContext, RegisterFriendCredentialsSchema, RegisterFriendCredentialsEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, RegisterFriendCredentialsEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=BasicAuthFriendModalMachine.d.ts.map