import { GQLDeleteOAuthFriendMutationData, GQLOAuthFriendConnectionReport } from './DeleteOAuthFriendModal.types';
export interface DeleteOAuthFriendModalStateSchema {
    states: {
        deleteOAuthFriendModal: {
            states: {
                loading: {};
                loaded: {};
                deletingFriend: {};
                success: {};
            };
        };
    };
}
export type SchemaValue = {
    deleteOAuthFriendModal: 'loading' | 'loaded' | 'deletingFriend' | 'success';
};
export interface DeleteOAuthFriendModalContext {
    oauthFriendConnectionReport: GQLOAuthFriendConnectionReport | null;
}
export type DeleteFriendEvent = {
    type: 'DELETE_FRIEND';
};
export type HandleFetchedReportEvent = {
    type: 'HANDLE_FETCHED_REPORT';
    oauthFriendConnectionReport: GQLOAuthFriendConnectionReport;
};
export type HandleDeletedFriendEvent = {
    type: 'HANDLE_DELETED_FRIEND';
    data: GQLDeleteOAuthFriendMutationData;
};
export type DeleteOAuthFriendModalEvent = DeleteFriendEvent | HandleFetchedReportEvent | HandleDeletedFriendEvent;
export declare const deleteOAuthFriendModalMachine: import("xstate").StateMachine<DeleteOAuthFriendModalContext, DeleteOAuthFriendModalStateSchema, DeleteOAuthFriendModalEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, DeleteOAuthFriendModalEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=DeleteOAuthFriendModalMachine.d.ts.map