import { GQLRenameOAuthFriendMutationData } from './RenameOAuthFriendModal.types';
export interface RenameOAuthFriendModalStateSchema {
    states: {
        renameOAuthFriendModal: {
            states: {
                pristine: {};
                valid: {};
                invalid: {};
                renamingOAuthFriend: {};
                success: {};
            };
        };
    };
}
export type SchemaValue = {
    renameOAuthFriendModal: 'pristine' | 'valid' | 'invalid' | 'renamingOAuthFriend' | 'success';
};
export interface RenameOAuthFriendModalContext {
    name: string | null;
    nameMessage: string | null;
    nameIsInvalid: boolean;
    initialName: string | null;
}
export type ChangeNameEvent = {
    type: 'CHANGE_NAME';
    name: string;
};
export type RenameFriendEvent = {
    type: 'RENAME_FRIEND';
};
export type HandleRenamedFriendEvent = {
    type: 'HANDLE_RENAMED_FRIEND';
    data: GQLRenameOAuthFriendMutationData;
};
export type RenameOAuthFriendModalEvent = ChangeNameEvent | RenameFriendEvent | HandleRenamedFriendEvent;
export declare const renameOAuthFriendModalMachine: import("xstate").StateMachine<RenameOAuthFriendModalContext, RenameOAuthFriendModalStateSchema, RenameOAuthFriendModalEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, RenameOAuthFriendModalEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=RenameOAuthFriendModalMachine.d.ts.map