/***********************************************************************************************
 * Copyright (c) 2025 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
/**
 * Hook that verifies whether a given ID is a valid representation ID in the default editing context of a given project.
 * @param projectId The ID of the project
 * @param representationId The ID of the representation, that may exist in a CommitEditingContext but not in the project's default editing context
 * @returns true if and only if the given ID matches a representation (i.e. a model object) in the given project's default editing context.
 */
export declare const useRepresentationExists: (projectId: string, representationId: string) => boolean;
//# sourceMappingURL=useRepresentationExists.d.ts.map