/***********************************************************************************************
 * Copyright (c) 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { AccessLevel } from '../../core/Core.types';
import { GQLExtConfiguration } from '../../core/oslc/globalconf/GlobalConf.types';
import { GQLInvalidLinkDescriptor } from '../../core/oslc/Oslc.types';
export interface GQLModelEventSubscription {
    modelEvent: GQLModelEventPayload;
}
export interface GQLModelEventPayload {
    __typename: string;
}
export interface GQLModelRefreshedEventPayload extends GQLModelEventPayload {
    id: string;
    summary: GQLModelSummary;
}
export interface GQLModelSummary {
    uid: string;
    projectId: string;
    exists: boolean;
    name: string;
    description: string;
    imageURL: string;
    assignedGlobalConf?: GQLExtConfiguration;
    invalidLinks: GQLInvalidLinkDescriptor[];
    unsynchronizedAttachments: GQLExtAttachmentDescriptor[];
    unsynchronizedAttachmentArtifacts: GQLExtAttachmentArtifactDescriptor[];
}
export type GQLGetProjectQueryData = {
    viewer: GQLViewer;
};
export type GQLGetProjectQueryVariables = {
    projectId: string;
};
export interface GQLViewer {
    project: GQLProject;
}
export interface GQLProject {
    id: string;
    accessLevel: AccessLevel;
    globalConf: boolean;
    currentUserGlobalConf?: GQLExtConfiguration;
}
export type GQLExtAttachmentDescriptor = {
    id: string;
    modelId: number;
    isSynced: boolean;
    objectId: string;
    objectLabel: string;
    objectTypeName: string;
    objectIconURL: string;
    syncErrorMessage: string;
};
export type GQLExtAttachmentArtifactDescriptor = {
    id: string;
    attachment: GQLExtAttachmentDescriptor;
    remoteUrl: string;
    remoteTitle: string;
    syncStatus: number;
    syncErrorMessage: string;
};
//# sourceMappingURL=Model.types.d.ts.map