/***********************************************************************************************
 * Copyright (c) 2025 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLMessage } from '@eclipse-sirius/sirius-components-core';
import { GQLFriendAuthProblemPayload } from '../../../core/oauth/OAuth.types';
export interface UseRetryUnsynchronizedAttachmentsValue {
    retryUnsynchronizedAttachments: (editingContextId: string, modelId: number, attachmentIds: string[], attachmentArtifactIds: string[]) => void;
    loading: boolean;
    attachmentsRetried: GQLRetryUnsynchronizedAttachmentsSuccessPayload | null;
    friendAuthProblemPayload: GQLFriendAuthProblemPayload | null;
}
export interface GQLRetryUnsynchronizedAttachmentsMutationData {
    retryUnsynchronizedAttachments: GQLRetryUnsynchronizedAttachmentsPayload;
}
export interface GQLRetryUnsynchronizedAttachmentsPayload {
    __typename: string;
}
export interface GQLRetryUnsynchronizedAttachmentsSuccessPayload extends GQLRetryUnsynchronizedAttachmentsPayload {
}
export interface GQLErrorPayload extends GQLRetryUnsynchronizedAttachmentsPayload {
    message: string;
    messages: GQLMessage[];
}
export interface GQLRetryUnsynchronizedAttachmentsMutationVariables {
    input: GQLRetryUnsynchronizedAttachmentsInput;
}
export interface GQLRetryUnsynchronizedAttachmentsInput {
    id: string;
    editingContextId: string;
    modelId: number;
    attachmentIds: string[];
    attachmentArtifactIds: string[];
}
//# sourceMappingURL=useRetryUnsynchronizedAttachments.types.d.ts.map