/***********************************************************************************************
 * Copyright (c) 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLMessage } from '@eclipse-sirius/sirius-components-core';
import { GQLTreeNode } from '@eclipse-sirius/sirius-components-forms';
import { AccessLevel } from '../../../../core/Core.types';
import { GQLOslcAssociationDescriptor, GQLOslcLinking, GQLUpdateModelObjectOslcLinksPayload } from '../../../../core/oslc/Oslc.types';
import { GQLModelObjectSummary } from '../../ModelObject.types';
export declare type OslcWidgetProps = {
    label: string;
    editingContextId: string;
    summary: GQLModelObjectSummary;
    nodes: GQLTreeNode[];
    rootNodes: GQLTreeNode[];
    readOnly: boolean;
    displayPreviews: boolean;
};
export interface GQLGetProjectQueryVariables {
    projectId: string;
    type: string;
}
export interface GQLGetProjectQueryData {
    viewer: GQLViewer;
}
export interface GQLViewer {
    project: GQLProject;
}
export interface GQLProject {
    id: string;
    accessLevel: AccessLevel;
    globalConf: boolean;
    oslcAssociations: GQLOslcAssociationDescriptor[];
    oslcLinkings: GQLOslcLinking[];
}
export interface GQLDeleteLinkMutationData {
    deleteOslcLink: GQLUpdateModelObjectOslcLinksPayload;
}
export interface GQLErrorPayload extends GQLUpdateModelObjectOslcLinksPayload {
    message: string;
    messages: GQLMessage[];
}
//# sourceMappingURL=OslcWidget.types.d.ts.map