import { GQLCreateFriendPayload } from './NewOAuthFriendView.types';
export interface NewOAuthFriendViewStateSchema {
    states: {
        newOAuthFriendView: {
            states: {
                pristine: {};
                invalid: {};
                valid: {};
                creatingFriend: {};
                success: {};
            };
        };
    };
}
export type SchemaValue = {
    newOAuthFriendView: 'pristine' | 'invalid' | 'valid' | 'creatingFriend' | 'success';
};
export interface NewOAuthFriendViewContext {
    name: string;
    nameMessage: string;
    nameIsInvalid: boolean;
    type: string;
    rootServicesURI: string;
    rootServicesURIMessage: string;
    rootServicesURIIsInvalid: boolean;
    secret: string;
    secretMessage: string;
    secretIsInvalid: boolean;
    confirmSecret: string;
    confirmSecretMessage: string;
    confirmSecretIsInvalid: boolean;
    trusted: boolean;
    newOAuthFriendKey: string | null;
}
export type ChangeNameEvent = {
    type: 'CHANGE_NAME';
    name: string;
};
export type ChangeTypeEvent = {
    type: 'CHANGE_TYPE';
    friendTypeId: string;
};
export type ChangeRootServicesURIEvent = {
    type: 'CHANGE_ROOT_SERVICES_URI';
    rootServicesURI: string;
};
export type ChangeSecretEvent = {
    type: 'CHANGE_SECRET';
    secret: string;
};
export type ChangeConfirmSecretEvent = {
    type: 'CHANGE_CONFIRM_SECRET';
    confirmSecret: string;
};
export type ChangeTrustedEvent = {
    type: 'CHANGE_TRUSTED';
    trusted: boolean;
};
export type CreateFriendEvent = {
    type: 'CREATE_FRIEND';
};
export type HandleCreatedFriendEvent = {
    type: 'HANDLE_CREATED_FRIEND';
    payload: GQLCreateFriendPayload;
};
export type NewOAuthFriendEvent = ChangeNameEvent | ChangeTypeEvent | ChangeRootServicesURIEvent | ChangeSecretEvent | ChangeConfirmSecretEvent | ChangeTrustedEvent | CreateFriendEvent | HandleCreatedFriendEvent;
export declare const newOAuthFriendViewMachine: import("xstate").StateMachine<NewOAuthFriendViewContext, NewOAuthFriendViewStateSchema, NewOAuthFriendEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, NewOAuthFriendEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=NewOAuthFriendViewMachine.d.ts.map