import { GQLOAuthFriend } from '../../core/oauth/OAuth.types';
import { GQLGetOAuthFriendsQueryData } from './OAuthFriendsView.types';
export interface OAuthFriendsViewStateSchema {
    states: {
        oauthFriendsView: {
            states: {
                loading: {};
                loaded: {};
                empty: {};
            };
        };
    };
}
export type SchemaValue = {
    oauthFriendsView: 'loading' | 'loaded' | 'empty';
};
export type OAuthFriendsViewModal = 'Rename' | 'Delete';
export interface OAuthFriendsViewContext {
    oauthFriends: GQLOAuthFriend[];
    selectedFriend: GQLOAuthFriend | null;
    menuAnchor: HTMLElement | null;
    modalToDisplay: OAuthFriendsViewModal | null;
}
export type OpenMenuEvent = {
    type: 'OPEN_MENU';
    menuAnchor: HTMLElement;
    selectedFriend: GQLOAuthFriend;
};
export type CloseMenuEvent = {
    type: 'CLOSE_MENU';
};
export type OpenModalEvent = {
    type: 'OPEN_MODAL';
    modalToDisplay: OAuthFriendsViewModal;
};
export type CloseModalEvent = {
    type: 'CLOSE_MODAL';
};
export type HandleFetchedFriendsEvent = {
    type: 'HANDLE_FETCHED_FRIENDS';
    data: GQLGetOAuthFriendsQueryData;
};
export type OAuthFriendsViewEvent = OpenMenuEvent | CloseMenuEvent | OpenModalEvent | CloseModalEvent | HandleFetchedFriendsEvent;
export declare const oauthFriendsViewMachine: import("xstate").StateMachine<OAuthFriendsViewContext, OAuthFriendsViewStateSchema, OAuthFriendsViewEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, OAuthFriendsViewEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=OAuthFriendsViewMachine.d.ts.map