/***********************************************************************************************
 * Copyright (c) 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLFriendAuthProblemPayload, GQLOAuthFriend, HandleFriendAuthProblemEvent } from '../../../core/oauth/OAuth.types';
import { GQLOslcServiceProvider } from '../../../core/oslc/Oslc.types';
import { GQLGetServiceProvidersMutationData } from './CreateOslcAssociation.types';
export interface CreateOslcAssociationStateSchema {
    states: {
        createOslcAssociation: {
            states: {
                idle: {};
                loading: {};
                approving: {};
                retrying: {};
            };
        };
    };
}
export type SchemaValue = {
    createOslcAssociation: 'idle' | 'loading' | 'approving' | 'retrying';
};
export interface CreateOslcAssociationContext {
    selectedOAuthFriend: GQLOAuthFriend | null;
    selectedServiceProvider: GQLOslcServiceProvider | null;
    serviceProviders: GQLOslcServiceProvider[] | null;
    friendAuthProblemPayload: GQLFriendAuthProblemPayload | null;
}
export type SelectFriendEvent = {
    type: 'SELECT_FRIEND';
    selectedOAuthFriend: GQLOAuthFriend;
};
export type RetryEvent = {
    type: 'RETRY';
};
export type SelectServiceProviderEvent = {
    type: 'SELECT_SERVICE_PROVIDER';
    selectedServiceProvider: GQLOslcServiceProvider;
};
export type HandleFetchedServiceProvidersEvent = {
    type: 'HANDLE_FETCHED_SERVICE_PROVIDERS';
    data: GQLGetServiceProvidersMutationData;
};
export type HandleFetchServiceProvidersErrorEvent = {
    type: 'HANDLE_FETCH_SERVICE_PROVIDERS_ERROR';
};
export type CreateOslcAssociationEvent = SelectFriendEvent | RetryEvent | SelectServiceProviderEvent | HandleFetchedServiceProvidersEvent | HandleFetchServiceProvidersErrorEvent | HandleFriendAuthProblemEvent;
export declare const createOslcAssociationMachine: import("xstate").StateMachine<CreateOslcAssociationContext, CreateOslcAssociationStateSchema, CreateOslcAssociationEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, CreateOslcAssociationEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=CreateOslcAssociationMachine.d.ts.map