import { GQLGetProjectQueryData } from './ProjectSettingsOslcLinkingView.types';
export interface ProjectSettingsOslcLinkingStateSchema {
    states: {
        projectSettingsOslcLinking: {
            states: {
                loading: {};
                loaded: {};
            };
        };
    };
}
export type SchemaValue = {
    projectSettingsOslcLinking: 'loading' | 'loaded';
};
export interface ProjectSettingsOslcLinkingContext {
    defaultOslcLinkingConfiguration: string | null;
    initialOslcLinkingConfiguration: string | null;
    oslcLinkingConfiguration: string | null;
    oslcLinkingConfigurationEnabled: boolean;
}
export type HandleFetchedProjectEvent = {
    type: 'HANDLE_FETCHED_PROJECT';
    data: GQLGetProjectQueryData;
};
export type ChangeConfigurationEvent = {
    type: 'CHANGE_CONFIGURATION';
    oslcLinkingConfiguration: string;
};
export type ProjectSettingsOslcLinkingEvent = HandleFetchedProjectEvent | ChangeConfigurationEvent;
export declare const projectSettingsOslcLinkingMachine: import("xstate").StateMachine<ProjectSettingsOslcLinkingContext, ProjectSettingsOslcLinkingStateSchema, ProjectSettingsOslcLinkingEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, ProjectSettingsOslcLinkingEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=ProjectSettingsOslcLinkingViewMachine.d.ts.map