/***********************************************************************************************
 * Copyright (c) 2021, 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLActivateProjectGlobalConfMutationData, GQLGetProjectQueryData, GQLProject } from './ProjectSettingsOverview.types';
export interface ProjectSettingsOverviewStateSchema {
    states: {
        projectSettingsOverview: {
            states: {
                loading: {};
                loaded: {};
                missing: {};
            };
        };
    };
}
export type SchemaValue = {
    projectSettingsOverview: 'loading' | 'loaded' | 'missing';
};
export interface ProjectSettingsOverviewContext {
    project: GQLProject | null;
}
export type HandleFetchedProjectEvent = {
    type: 'HANDLE_FETCHED_PROJECT';
    data: GQLGetProjectQueryData;
};
export type HandleActivateProjectGlobalConfEvent = {
    type: 'HANDLE_ACTIVATE_PROJECT_GLOBAL_CONF';
    data: GQLActivateProjectGlobalConfMutationData;
};
export type ProjectSettingsOverviewEvent = HandleFetchedProjectEvent | HandleActivateProjectGlobalConfEvent;
export declare const projectSettingsOverviewMachine: import("xstate").StateMachine<ProjectSettingsOverviewContext, ProjectSettingsOverviewStateSchema, ProjectSettingsOverviewEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, ProjectSettingsOverviewEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=ProjectSettingsOverviewMachine.d.ts.map