import { GQLSearchResult, GQLSearchResultConnection, SearchInput } from '../../common/SearchCommon.types';
export interface ResultGroupStateSchema {
    states: {
        resultGroup: {
            states: {
                unloaded: {};
                loadRequested: {};
                loading: {};
                loaded: {};
            };
        };
    };
}
export type SchemaValue = {
    resultGroup: 'unloaded' | 'loadRequested' | 'loading' | 'loaded';
};
export interface ResultGroupContext {
    groupSearchInput: SearchInput | null;
    searchResultConnection: GQLSearchResultConnection | null;
}
export type LoadEvent = {
    type: 'LOAD';
};
export type LoadingEvent = {
    type: 'LOADING';
    groupSearchInput: SearchInput;
};
export type HandleFetchedResultEvent = {
    type: 'HANDLE_FETCHED_RESULT';
    searchResult: GQLSearchResult;
};
export type ResultGroupEvent = LoadEvent | LoadingEvent | HandleFetchedResultEvent;
export declare const resultGroupMachine: import("xstate").StateMachine<ResultGroupContext, ResultGroupStateSchema, ResultGroupEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, ResultGroupEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=ResultGroupMachine.d.ts.map