import { GQLOAuthFriend } from '../../../core/oauth/OAuth.types';
import { GQLGetOAuthFriendData } from './FriendCredentialsSettings.types';
export interface FriendCredentialsSettingsSchema {
    states: {
        friendCredentialsSettings: {
            states: {
                loading: {};
                loaded: {};
                saved: {};
                invalid: {};
            };
        };
    };
}
export type SchemaValue = {
    friendCredentialsSettings: 'loading' | 'loaded' | 'saved' | 'invalid';
};
export interface FriendCredentialsSettingsContext {
    friend: GQLOAuthFriend | null;
}
export type HandleFetchedFriendSuccessEvent = {
    type: 'HANDLE_FETCHED_FRIEND_SUCCESS';
    data: GQLGetOAuthFriendData;
};
export type HandleFetchedFriendErrorEvent = {
    type: 'HANDLE_FETCHED_FRIEND_ERROR';
};
export type HandleCredentialsSavedEvent = {
    type: 'HANDLE_CREDENTIALS_SAVED';
};
export type FriendCredentialsSettingsEvent = HandleFetchedFriendSuccessEvent | HandleFetchedFriendErrorEvent | HandleCredentialsSavedEvent;
export declare const friendCredentialsSettingsMachine: import("xstate").StateMachine<FriendCredentialsSettingsContext, FriendCredentialsSettingsSchema, FriendCredentialsSettingsEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, FriendCredentialsSettingsEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=FriendCredentialsSettingsMachine.d.ts.map