import { GQLGetMetaclassFiltersQueryData, GQLMetaclassFilter, GQLMetaclassFilterSettings, GQLUpdateMetaclassFilterSettingsMutationData } from './MetaclassFilterSettings.types';
export interface MetaclassFilterSettingsStateSchema {
    states: {
        metaclassFilterSettings: {
            states: {
                loading: {};
                loaded: {};
                saving: {};
                restoringDefaults: {};
                reloadingDefaults: {};
            };
        };
    };
}
export type SchemaValue = {
    metaclassFilterSettings: 'loading' | 'loaded' | 'saving' | 'restoringDefaults' | 'reloadingDefaults';
};
export interface MetaclassFilterSettingsContext {
    metaclassFilters: GQLMetaclassFilter[];
    savedFilters: GQLMetaclassFilter[];
    newPattern: string;
    newPatternIsInvalid: boolean;
    newPatternMessage: string;
    isDirty: boolean;
    serverDefaults: boolean;
}
export type HandleFetchedSettingsEvent = {
    type: 'HANDLE_FETCHED_SETTINGS';
    data: GQLGetMetaclassFiltersQueryData;
};
export type SaveSettingsEvent = {
    type: 'SAVE_SETTINGS';
    data: GQLUpdateMetaclassFilterSettingsMutationData;
};
export type ChangeMetaclassListEvent = {
    type: 'CHANGE_MC_LIST';
    newList: string[];
    metamodelPattern: string;
};
export type ChangeNewPatternEvent = {
    type: 'CHANGE_NEW_PATTERN';
    newPattern: string;
};
export type AddPatternEvent = {
    type: 'ADD_PATTERN';
    newPattern: string;
};
export type DeletePatternEvent = {
    type: 'DELETE_PATTERN';
    pattern: string;
};
export type ResetSettingsEvent = {
    type: 'RESET_SETTINGS';
    savedFilters: GQLMetaclassFilter[];
};
export type RestoreDefaultSettingsEvent = {
    type: 'RESTORE_DEFAULTS';
};
export type HandleSavedEvent = {
    type: 'HANDLE_SAVED';
    data: GQLMetaclassFilterSettings;
};
export type HandleSaveErrorEvent = {
    type: 'HANDLE_SAVE_ERROR';
    message: string;
};
export type ReloadDefaultSettingsEvent = {
    type: 'RELOAD_DEFAULTS';
};
export type HandleReloadedEvent = {
    type: 'HANDLE_RELOADED';
    data: GQLMetaclassFilterSettings;
};
export type HandleReloadErrorEvent = {
    type: 'HANDLE_RELOAD_ERROR';
    message: string;
};
export type MetaclassFilterSettingsEvent = HandleFetchedSettingsEvent | SaveSettingsEvent | ChangeMetaclassListEvent | ChangeNewPatternEvent | AddPatternEvent | DeletePatternEvent | ResetSettingsEvent | RestoreDefaultSettingsEvent | HandleSavedEvent | HandleSaveErrorEvent | ReloadDefaultSettingsEvent | HandleReloadedEvent | HandleReloadErrorEvent;
export declare const metaclassFilterSettingsMachine: import("xstate").StateMachine<MetaclassFilterSettingsContext, MetaclassFilterSettingsStateSchema, MetaclassFilterSettingsEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, MetaclassFilterSettingsEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=MetaclassFilterSettingsMachine.d.ts.map