/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.config;

import fr.obeo.perseus.server.jobs.JobStatus;
import fr.obeo.perseus.server.meta.services.api.IMetaclassRegistry;
import fr.obeo.perseus.server.meta.services.api.IMetamodelRegistry;
import fr.obeo.perseus.server.repositories.IModelRepository;
import fr.obeo.perseus.server.services.IModelContext;
import fr.obeo.perseus.server.services.IModelMappingResolver;
import fr.obeo.perseus.server.services.ModelContext;
import fr.obeo.perseus.server.services.ModelMappingResolver;
import fr.obeo.perseus.server.services.api.jobs.IRunnableJob;
import fr.obeo.perseus.server.services.jobs.JobStatusChangedEvent;
import fr.obeo.perseus.server.services.jobs.PublishModelJob;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class ModelApplicationConfig {
    @Autowired
    private IModelRepository modelRepository;
    @Autowired
    private IMetamodelRegistry mmRegistry;
    @Autowired
    private IMetaclassRegistry mcRegistry;
    private Map<Long, IModelContext> modelContexts = Collections.synchronizedMap(new LinkedHashMap());

    @Bean
    Function<Long, IModelContext> modelContextProvider() {
        return arg_0 -> this.getModelContext(arg_0);
    }

    private IModelContext getModelContext(long modelId) {
        return this.modelContexts.computeIfAbsent(modelId, id -> new ModelContext(this.mmRegistry, this.mcRegistry, (IModelMappingResolver)new ModelMappingResolver(id.longValue(), this.modelRepository, this.mmRegistry)));
    }

    @EventListener
    public void onJobStatusChanged(JobStatusChangedEvent evt) {
        IRunnableJob iRunnableJob;
        if (JobStatus.DONE.equals((Object)evt.newStatus()) && (iRunnableJob = evt.job()) instanceof PublishModelJob) {
            PublishModelJob job = (PublishModelJob)iRunnableJob;
            this.modelContexts.remove(job.getUid());
        }
    }
}

