/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.app.controllers.editingContext.CommitModelObjectsDataFetcherDelegate;
import fr.obeo.perseus.server.app.controllers.editingContext.ProjectModelObjectsDataFetcherDelegate;
import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.GQLModelObjectRef;
import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.core.api.IEditingContextSearchService;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;

@QueryDataFetcher(type="EditingContext", field="modelObjects")
public class EditingContextModelObjectsDataFetcher
implements IDataFetcherWithFieldCoordinates<List<GQLModelObjectRef>> {
    private static final String ARG_OBJECT_IDS = "objectIds";
    private static final String ARG_MODEL_ID = "modelId";
    private final IEditingContextSearchService editingContextSearchService;
    private final ProjectModelObjectsDataFetcherDelegate projectDelegate;
    private final CommitModelObjectsDataFetcherDelegate commitDelegate;

    public EditingContextModelObjectsDataFetcher(IEditingContextSearchService editingContextSearchService, ProjectModelObjectsDataFetcherDelegate projectDelegate, CommitModelObjectsDataFetcherDelegate commitDelegate) {
        this.editingContextSearchService = Objects.requireNonNull(editingContextSearchService);
        this.projectDelegate = Objects.requireNonNull(projectDelegate);
        this.commitDelegate = Objects.requireNonNull(commitDelegate);
    }

    public List<GQLModelObjectRef> get(DataFetchingEnvironment environment) throws Exception {
        String editingContextId = (String)environment.getSource();
        Optional optEditingContext = this.editingContextSearchService.findById(editingContextId);
        return optEditingContext.map(editingContext -> {
            List uids = (List)environment.getArgument(ARG_OBJECT_IDS);
            Number modelId = (Number)environment.getArgument(ARG_MODEL_ID);
            if (editingContext instanceof ProjectEditingContext) {
                ProjectEditingContext pec = (ProjectEditingContext)editingContext;
                return this.projectDelegate.get(pec, uids, modelId);
            }
            if (editingContext instanceof CommitEditingContext) {
                CommitEditingContext cec = (CommitEditingContext)editingContext;
                return this.commitDelegate.get(cec, uids, modelId);
            }
            return List.of();
        }).orElseGet(List::of);
    }
}

