/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.ocp.application.permissions.services.api.IPermissionApplicationService;
import graphql.schema.DataFetchingEnvironment;
import java.util.Set;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.web.application.project.dto.ProjectDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jdbc.core.mapping.AggregateReference;

@QueryDataFetcher(type="Project", field="accessLevel")
public class ProjectAccessLevelDataFetcher
implements IDataFetcherWithFieldCoordinates<String> {
    @Autowired
    private IPermissionApplicationService permissionApplicationService;

    public String get(DataFetchingEnvironment environment) throws Exception {
        ProjectDTO project = (ProjectDTO)environment.getSource();
        String projectId = project.id();
        AggregateReference projectRef = AggregateReference.to((Object)projectId);
        Set accessLevels = this.permissionApplicationService.getCurrentUserProjectAccessLevels(projectRef);
        if (accessLevels.contains("ADMIN")) {
            return "ADMIN";
        }
        if (accessLevels.contains("WRITE")) {
            return "WRITE";
        }
        if (accessLevels.contains("READ")) {
            return "READ";
        }
        return "NONE";
    }
}

