/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.services.api.dto.versioning.BaselineDTO;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.repositories.IBaselineRepository;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;

@QueryDataFetcher(type="Project", field="baseline")
public class ProjectBaselineDataFetcher
implements IDataFetcherWithFieldCoordinates<BaselineDTO> {
    private static final String BASELINE_ID_ARGUMENT = "baselineId";
    private final IBaselineRepository baselineRepository;
    private final ModelEntityToDTO entityToDTO;

    public ProjectBaselineDataFetcher(IBaselineRepository baselineRepository, ModelEntityToDTO entityToDTO) {
        this.baselineRepository = Objects.requireNonNull(baselineRepository);
        this.entityToDTO = Objects.requireNonNull(entityToDTO);
    }

    public BaselineDTO get(DataFetchingEnvironment environment) throws Exception {
        String baselineId = (String)environment.getArgument(BASELINE_ID_ARGUMENT);
        return this.baselineRepository.findById((Object)UUID.fromString(baselineId)).map(arg_0 -> ((ModelEntityToDTO)this.entityToDTO).convert(arg_0)).orElse(null);
    }
}

