/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.app.data.FullCommitID;
import fr.obeo.perseus.server.app.services.ICommitEditingContextService;
import fr.obeo.perseus.server.versioning.api.IBaselineSearchService;
import fr.obeo.perseus.server.versioning.api.IHistorySearchService;
import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.web.application.project.dto.ProjectDTO;

@QueryDataFetcher(type="Project", field="baselineEditingContext")
public class ProjectBaselineEditingContextDataFetcher
implements IDataFetcherWithFieldCoordinates<DataFetcherResult<String>> {
    private static final String BASELINE_ID = "baselineId";
    private final ICommitEditingContextService commitEditingContextService;
    private final IBaselineSearchService baselineSearchService;
    private final IHistorySearchService historySearchService;

    public ProjectBaselineEditingContextDataFetcher(ICommitEditingContextService commitEditingContextService, IBaselineSearchService baselineSearchService, IHistorySearchService historySearchService) {
        this.commitEditingContextService = Objects.requireNonNull(commitEditingContextService);
        this.baselineSearchService = Objects.requireNonNull(baselineSearchService);
        this.historySearchService = Objects.requireNonNull(historySearchService);
    }

    public DataFetcherResult<String> get(DataFetchingEnvironment environment) throws Exception {
        ProjectDTO project = (ProjectDTO)environment.getSource();
        UUID baselineId = UUID.fromString((String)environment.getArgument(BASELINE_ID));
        return this.baselineSearchService.getBaseline(baselineId).flatMap(baseline -> this.historySearchService.findHistory(baseline.getHistoryId()).filter(history -> project.id().equals(history.getProjectId())).flatMap(history -> {
            FullCommitID fullCommitId = new FullCommitID(history.getProjectId(), baseline.getCommitId());
            return this.commitEditingContextService.getEditingContextId(fullCommitId);
        })).map(arg_0 -> this.toDataFetcherResult(arg_0)).orElseGet(() -> DataFetcherResult.newResult().error(GraphQLError.newError().errorType(ErrorClassification.errorClassification((String)"Invalid or forbidden Baseline ID")).message("Invalid, forbidden, or deleted Baseline ID.", new Object[0]).build()).build());
    }

    private DataFetcherResult<String> toDataFetcherResult(String editingContextId) {
        HashMap<String, String> localContext = new HashMap<String, String>();
        localContext.put("editingContextId", editingContextId);
        return DataFetcherResult.newResult().data((Object)editingContextId).localContext(localContext).build();
    }
}

