/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.services.api.dto.versioning.CommitDTO;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.repositories.ICommitRepository;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;

@QueryDataFetcher(type="Project", field="commit")
public class ProjectCommitDataFetcher
implements IDataFetcherWithFieldCoordinates<CommitDTO> {
    private static final String BRANCH_ID_ARGUMENT = "branchId";
    private static final String VERSION_ARGUMENT = "version";
    private final ICommitRepository commitRepository;
    private final ModelEntityToDTO entityToDTO;

    public ProjectCommitDataFetcher(ICommitRepository commitRepository, ModelEntityToDTO entityToDTO) {
        this.commitRepository = Objects.requireNonNull(commitRepository);
        this.entityToDTO = Objects.requireNonNull(entityToDTO);
    }

    public CommitDTO get(DataFetchingEnvironment environment) throws Exception {
        String branchId = (String)environment.getArgument(BRANCH_ID_ARGUMENT);
        Number version = (Number)environment.getArgument(VERSION_ARGUMENT);
        return this.commitRepository.findById((Object)new CommitID(UUID.fromString(branchId), version.intValue())).map(arg_0 -> ((ModelEntityToDTO)this.entityToDTO).convert(arg_0)).orElse(null);
    }
}

