/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.common.services.api.IUriProvider;
import fr.obeo.perseus.server.meta.MetaclassDescriptorDTO;
import fr.obeo.perseus.server.meta.entities.IMClassifier;
import fr.obeo.perseus.server.services.api.IModelMetaclassSearchService;
import graphql.schema.DataFetchingEnvironment;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.web.application.project.dto.ProjectDTO;

@QueryDataFetcher(type="Project", field="metaclassDescriptors")
public class ProjectMetaclassDescriptorsDataFetcher
implements IDataFetcherWithFieldCoordinates<Set<MetaclassDescriptorDTO>> {
    private static final String MODEL_ID_ARGUMENT = "modelId";
    private final IModelMetaclassSearchService modelMetaclassSearchService;
    private final IUriProvider uriProvider;

    public ProjectMetaclassDescriptorsDataFetcher(IModelMetaclassSearchService modelMetaclassSearchService, IUriProvider uriProvider) {
        this.modelMetaclassSearchService = Objects.requireNonNull(modelMetaclassSearchService);
        this.uriProvider = Objects.requireNonNull(uriProvider);
    }

    public Set<MetaclassDescriptorDTO> get(DataFetchingEnvironment environment) throws Exception {
        ProjectDTO project = (ProjectDTO)environment.getSource();
        String projectId = project.id();
        Number modelId = (Number)environment.getArgument(MODEL_ID_ARGUMENT);
        Stream resultStream = null;
        if (modelId == null) {
            Set allMetaclasses = this.modelMetaclassSearchService.getAllMetaclassesUsedInProject(projectId);
            resultStream = allMetaclasses.stream();
        } else {
            resultStream = this.modelMetaclassSearchService.getAllMetaclassesUsedInModel(modelId.longValue()).stream();
        }
        return resultStream.sorted(Comparator.comparing(IMClassifier::getName)).map(metaclass -> new MetaclassDescriptorDTO(String.valueOf(metaclass.getId()), metaclass.getName(), this.uriProvider.getURI(metaclass, IUriProvider.UriKind.ICON).toString())).collect(Collectors.toSet());
    }
}

