/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.services.api.dto.versioning.BaselineDTO;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.api.IBaselineSearchService;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.web.application.project.dto.ProjectDTO;

@QueryDataFetcher(type="Project", field="modelBaselines")
public class ProjectModelBaselinesDataFetcher
implements IDataFetcherWithFieldCoordinates<List<BaselineDTO>> {
    private static final String MODEL_ID_ARGUMENT = "modelId";
    private final IHistoryOfModelSearchService historyOfModelSearchService;
    private final IBaselineSearchService baselineSearchService;
    private final ModelEntityToDTO entityToDTO;

    public ProjectModelBaselinesDataFetcher(IBaselineSearchService baselineSearchService, IHistoryOfModelSearchService historyOfModelSearchService, ModelEntityToDTO entityToDTO) {
        this.baselineSearchService = Objects.requireNonNull(baselineSearchService);
        this.historyOfModelSearchService = Objects.requireNonNull(historyOfModelSearchService);
        this.entityToDTO = Objects.requireNonNull(entityToDTO);
    }

    public List<BaselineDTO> get(DataFetchingEnvironment environment) throws Exception {
        ProjectDTO project = (ProjectDTO)environment.getSource();
        String projectId = project.id();
        Number modelId = (Number)environment.getArgument(MODEL_ID_ARGUMENT);
        return this.historyOfModelSearchService.findModelHistory(projectId, modelId.longValue()).map(history -> this.baselineSearchService.getAllBaselinesByHistoryId(history.getId()).stream().map(arg_0 -> ((ModelEntityToDTO)this.entityToDTO).convert(arg_0)).toList()).orElseGet(List::of);
    }
}

