/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.services.api.dto.versioning.CommitDTO;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.web.application.project.dto.ProjectDTO;

@QueryDataFetcher(type="Project", field="modelCommits")
public class ProjectModelCommitsDataFetcher
implements IDataFetcherWithFieldCoordinates<List<CommitDTO>> {
    private static final String MAX_VERSION_ARGUMENT = "maxVersion";
    private static final String LIMIT_ARGUMENT = "limit";
    private static final String MODEL_ID_ARGUMENT = "modelId";
    private final IHistoryOfModelSearchService historyOfModelSearchService;
    private final ICommitSearchService commitSearchService;
    private final ModelEntityToDTO entityToDTO;

    public ProjectModelCommitsDataFetcher(IHistoryOfModelSearchService historyOfModelSearchService, ICommitSearchService commitSearchService, ModelEntityToDTO entityToDTO) {
        this.historyOfModelSearchService = Objects.requireNonNull(historyOfModelSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.entityToDTO = Objects.requireNonNull(entityToDTO);
    }

    public List<CommitDTO> get(DataFetchingEnvironment environment) throws Exception {
        Optional<Integer> maxVersion = Optional.ofNullable((Integer)environment.getArgument(MAX_VERSION_ARGUMENT));
        int limit = (Integer)environment.getArgument(LIMIT_ARGUMENT);
        ProjectDTO project = (ProjectDTO)environment.getSource();
        String projectId = project.id();
        Number modelId = (Number)environment.getArgument(MODEL_ID_ARGUMENT);
        return this.historyOfModelSearchService.findModelHistory(projectId, modelId.longValue()).map(history -> this.commitSearchService.getCommits(history, maxVersion, limit)).orElse(Collections.emptyList()).stream().map(arg_0 -> ((ModelEntityToDTO)this.entityToDTO).convert(arg_0)).toList();
    }
}

